/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Swac-explore is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _EXPLORER_HH
#define _EXPLORER_HH

#include <gtkmm/main.h>
#include "sqlite3++.hh"
#include "gstreamer.hh"
#include "explorer_static.hh"
#include "gconfmm.h"

#define GCONF_DIR "/apps/swac-explore"
#define GCONF_LANG GCONF_DIR "/user_lang"


class Explorer : public ExplorerStatic {  
private:      
	void on_quitter1_activate();
	void on_treeview2_cursor_changed();
	void on_combobox1_changed();
	void on_search_clicked();
	void on_combobox2_changed();
	void on_about();
	void on_treeview1_cursor_changed();

	void show_sound_info(Glib::ustring idx);
	void show_lang(Glib::ustring selected = "");
	void show_index();
	void show_index_else(Glib::ustring lang, Glib::ustring field);
	void show_index_alphaidx(Glib::ustring lang);
	void select_index_alphaidx(Glib::ustring lang, Glib::ustring str);
	int show_sounds(Glib::ustring filter);
	void search(Glib::ustring str);
	bool search_key_press(GdkEventKey* event);
	bool view_key_press(GdkEventKey* event);
	bool search_focus_out(GdkEventFocus* event);
	void play();
	void append_missing(Glib::ustring const lang, Glib::ustring const str);

	Glib::ustring user_lang;
	Glib::ustring user_index_field;

	Glib::RefPtr<Gnome::Conf::Client> gconf;
	SqlDatabase *db;  
	Gst *gst;
public:
	Explorer(SqlDatabase *_db, Gst *_gst, Glib::RefPtr<Gnome::Conf::Client> gconf);
};




#endif
