//  $Id: Options.cxx 493 2004-12-21 03:12:00Z grumbel $
//
//  TuxKart - a fun racing game with go-kart
//  Copyright (C) 2004 Steve Baker <sjbaker1@airmail.net>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "Options.h"
#include "tuxkart.h"
#include "WidgetSet.h"

Options::Options()
{
	menu_id = widgetSet -> varray(0);

	widgetSet -> label(menu_id, "Options", GUI_LRG, GUI_ALL, 0, 0);
	widgetSet -> start(menu_id, "Controls",  GUI_MED, MENU_CONTROLS, 0);
	widgetSet -> state(menu_id, "Display",  GUI_MED, MENU_DISPLAY, 0);
	widgetSet -> state(menu_id, "Sound",  GUI_MED, 0, 0);
	widgetSet -> space(menu_id);
	
	widgetSet -> layout(menu_id, 0, -1);
}

Options::~Options()
{
	widgetSet -> delete_widget(menu_id) ;
}
	
void Options::update(float dt)
{
	widgetSet -> timer(menu_id, dt) ;
  // This menu can be triggered from the game, when it is paused
  // so we have to check it and draw it as in pause
  if(widgetSet -> get_paused())
    widgetSet -> blank() ;
	widgetSet -> paint(menu_id) ;
}

void Options::select()
{
	switch ( widgetSet -> token (widgetSet -> click()) )
	{
	case MENU_CONTROLS: guiStack.push_back(GUIS_CONFIGCONTROLS); break;
	case MENU_DISPLAY: guiStack.push_back(GUIS_CONFIGDISPLAY); break;
	default: break;
	}
}


