/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <krun.h>
#include "textlabel.h"

TextLabel::TextLabel( int x,int y,int w,int h)
        : Meter(x,y,w,h)
{
    lineHeight = QFontMetrics(font).height();
    if( h != 0 || w != 0)
        clip = 0;
    else
        clip = Qt::DontClip;

    if( h == 0 || w == 0)
    {
        setWidth(-1);
        setHeight(-1);
    }
    textHidden = 0;
}

TextLabel::TextLabel()
{
  textHidden = 0;
}

TextLabel::~TextLabel()
{
}

void TextLabel::showText(){
  textHidden = 0;
  setEnabled(true);
}
void TextLabel::hideText(){
  textHidden = 1;
  setEnabled(false);
}


void TextLabel::setTextProps( TextField* t )
{
  text = *t;
  //lineHeight = t->getLineHeight();
  shadow = t->getShadow();
  alignment = t->getAlignment();
  setFontSize(t->getFontSize());
  setFont(t->getFont());
 
  int r, g, b;
  t->getColor().rgb ( &r, &g, &b );
  setColor( r, g, b );
  t->getBGColor().rgb ( &r, &g, &b );
  setBGColor( r, g, b );

  lineHeight = QFontMetrics(font).height();
}

void TextLabel::setValue( QString text)
{
    value = QStringList::split('\n',text);
}

void TextLabel::setValue( int v)
{
    value = QStringList( QString::number( v ) );
}

void TextLabel::setColor(int r, int g, int b)
{
    color.setRgb(r,g,b);
}

QColor TextLabel::getColor() const
{
    return color;
}

void TextLabel::setBGColor( int r, int g, int b )
{
    bgColor.setRgb( r, g, b );
}

QColor TextLabel::getBGColor() const
{
    return bgColor;
}


void TextLabel::setFont(QString f)
{
    font.setFamily(f);
    lineHeight = QFontMetrics(font).height();
}


QString TextLabel::getFont() const
{
    return font.family();
}

void TextLabel::setFontSize(int size)
{
    font.setPixelSize(size);
    lineHeight = QFontMetrics(font).height();
}

int TextLabel::getFontSize() const
{
    return font.pointSize();
}

void TextLabel::setAlignment( QString align )
{
    QString a = align.upper();
    if( a == "LEFT" || a == "" )
        alignment = Qt::AlignLeft;
    if( a == "RIGHT" )
        alignment = Qt::AlignRight;
    if( a == "CENTER" )
        alignment = Qt::AlignHCenter;
}

QString TextLabel::getAlignment() const
{
    if( alignment == Qt::AlignHCenter )
        return "CENTER";
    else if( alignment == Qt::AlignRight )
        return "RIGHT";
    else
        return "LEFT";
}

void TextLabel::setFixedPitch( bool fp)
{
    font.setFixedPitch( fp );
}

bool TextLabel::getFixedPitch() const
{
    return font.fixedPitch();
}

void TextLabel::setShadow ( int s )
{
    shadow = s;
}


int TextLabel::getShadow() const
{
    return shadow;
}

void TextLabel::mUpdate(QPainter *p)
{
    int i = 0; //lineHeight;
    int row = 1;

    int x = getX();
    int y = getY();
    int width = getWidth();
    int height = getHeight();

    if (textHidden != 1) {
      p->setFont(font);
      QStringList::Iterator it = value.begin();
      while( it != value.end() && (row <= height || height == -1 )   )
	{
	  if( shadow != 0)
	    {
	      p->setPen(getBGColor()  );
	      p->drawText(x+shadow, y+i+shadow, width,
			  height, alignment | clip | Qt::ExpandTabs,*it);
	    }
	  p->setPen( getColor() );
	  p->drawText(x,y+i,width,height, alignment | clip | Qt::ExpandTabs,*it);
	  i += lineHeight;
	  it++;
	  row++;
	}
    }

//     int i = 0; //lineHeight;
//     int row = 1;

//     p->setFont(text.getFont());
//     QStringList::Iterator it = value.begin();
//     while( it != value.end() && (row <= height || height == -1 )   )
//     {
//         if( text.getShadow() != 0)
//         {
//             p->setPen( text.getBGColor() );
//             p->drawText(x+text.getShadow(), y+i+text.getShadow(), width,
//                         height, text.getAlignment() | clip | Qt::ExpandTabs,*it);
//         }
//         p->setPen( text.getColor() );
//         p->drawText(x,y+i,width,height, text.getAlignment() | clip | Qt::ExpandTabs,*it);
//         i += text.getLineHeight();
//         it++;
//         row++;
//     }
}

bool TextLabel::click(QMouseEvent* e)
{
    if (getBoundingBox().contains(e -> x(), e -> y()) && isEnabled())
    {
        QString program;
        if (e -> button() == Qt::LeftButton)
        {
            program = leftButtonAction;
        }
        else if (e -> button() == Qt::MidButton)
        {
            program = middleButtonAction;
        }
        else if (e -> button() == Qt::RightButton)
        {
            program = rightButtonAction;
        }

        if( program != "" )
        {
            KRun::runCommand(program);
        } else {
	  return true;
	}
    }
    return false;
}

void TextLabel::attachClickArea(QString leftMouseButton, QString middleMouseButton, QString rightMouseButton)
{
    leftButtonAction = leftMouseButton;
    middleButtonAction = middleMouseButton;
    rightButtonAction = rightMouseButton;
}







