/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "sensorsensor.h"


SensorSensor::SensorSensor( int interval ) : Sensor( interval )
{
    connect(&ksp, SIGNAL(receivedStdout(KProcess *, char *, int )),
            this,SLOT(receivedStdout(KProcess *, char *, int )));
    connect(&ksp, SIGNAL(processExited(KProcess *)),
            this,SLOT(processExited( KProcess * )));

    // readValues();
}


SensorSensor::~SensorSensor()
{
}

void SensorSensor::receivedStdout(KProcess *, char *buffer, int len )
{
    buffer[len] = 0;
    sensorResult += QString( QCString(buffer) );
}

void SensorSensor::processExited(KProcess *)
{
    QStringList stringList = QStringList::split('\n',sensorResult);
    sensorResult = "";
    QStringList::Iterator it = stringList.begin();
    QRegExp rx( "^(\\S+):\\s+[\\+\\-]?(\\d+\\.?\\d*)");

    while( it != stringList.end())
    {
        rx.search( *it );

        if ( !rx.cap(0).isEmpty())
        {
            sensorMap[rx.cap(1)] = rx.cap(2);
        }
        it++;
    }

    QString format;
    QString type;
    SensorParams *sp;
    Meter *meter;

    QObjectListIt lit( *objList );
    while (lit != 0)
    {
        sp = (SensorParams*)(*lit);
        meter = sp->getMeter();
        format = sp->getParam("FORMAT");
        type = sp->getParam("TYPE");

        if (type.length() == 0)
            type = "temp2";

        if (format.length() == 0 )
        {
            format = "%v";
        }
        format.replace( QRegExp("%v", false), sensorMap[type]);
        meter->setValue(format);
        ++lit;
    }
}

void SensorSensor::update()
{
    ksp.clearArguments();
    ksp << "sensors";
    ksp.start( KProcess::NotifyOnExit,KProcIO::Stdout);
}

