/*
 * Copyright (C) 2003 Hans Karlsson <karlsson.h@home.se>
 */


#include <Python.h>

#include <kapplication.h>


#include <kfiledialog.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmainwindow.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qstringlist.h>
#include <kconfig.h>

#include "karamba.h"
#include "karambasessionmanaged.h"
#include "welcomeform.h"

static const char *description =
    I18N_NOOP("A KDE Eye-candy Application");

static const char *version = "0.33";

static KCmdLineOptions options[] =
    {
        //    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
        { "+file", I18N_NOOP("A required argument 'file'."), 0 },
        { 0, 0, 0 }

    };

    PyThreadState * mainThreadState;

int main(int argc, char **argv)
{
    KAboutData about("superkaramba", I18N_NOOP("superkaramba"), version, description,
                     KAboutData::License_GPL, "(C) 2003 Adam Geitgey", 0, 0, "adam@rootnode.org");
    about.addAuthor( "Adam Geitgey", 0, "adam@rootnode.org" );
    about.addAuthor( "Hans Karlsson", 0, "karlsson.h@home.se" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication app;

    KSessionManaged ksm;
    
    karamba *mainWin = 0;

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    bool OK = false;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name());

    // Create ~/.superkaramba if necessary
    QDir configDir(QDir::home().absPath() + "/.superkaramba");
    if (!configDir.exists())
    {
      qWarning("~/.superkaramba doesn't exist");
      if(!configDir.mkdir(QDir::home().absPath() + "/.superkaramba"))
      {
         qWarning("Couldn't create Directory ~/.superkaramba");
      }
      else
      {
         qWarning("created ~/.superkaramba");
      }
    }



    // initialize Python
    Py_Initialize();

    // initialize thread support
    PyEval_InitThreads();

    mainThreadState = NULL;

    // save a pointer to the main PyThreadState object
    mainThreadState = PyThreadState_Get();

    // release the lock
    PyEval_ReleaseLock();


    /******
	   Try to restore a previous session if applicable.
    */
    if (app.isSessionRestored()) {

      KConfig* config = kapp->sessionConfig();
      config->setGroup("General Options");
      QString restartThemes = config->readEntry("OpenThemes","");

      //Get themes that were running
      QStringList lst (QStringList::split(QString(";"), restartThemes));
      
        for ( QStringList::Iterator it = lst.begin(); it != lst.end(); ++it )
        {
            QFileInfo file( *it );
            if( file.exists() && !file.isDir() )
            {
                mainWin = new karamba( *it , false);
                mainWin->show();
                OK = true;
            }
        }
        int ret = 0;
        if( OK )
            ret = app.exec();

	// shut down the interpreter
	PyInterpreterState * mainInterpreterState = mainThreadState->interp;
	// create a thread state object for this thread
	PyThreadState * myThreadState = PyThreadState_New(mainInterpreterState);
	PyThreadState_Swap(myThreadState);
	PyEval_AcquireLock();
	Py_Finalize();
        return ret;      

    }
    
    /******
	   Not a saved session - check for themes given on command line
    */
    else if(args->count() > 0) {
      for (int i = 0; i < (args->count()); i++)
        {
	  if( args->arg(i) != "" )
            {
                QFileInfo file( args->arg(i) );
                //qDebug( file.dirPath(true) );
                if( file.exists() && !file.isDir() )
		  {
                    //qDebug( "File exists" );
                    mainWin = new karamba( ( args->arg(i) ), false);
                    mainWin->show();
                    OK = true;
		  }
            }
        }
      
      //app.setMainWidget( mainWin );
      int ret = 0;
      if( OK )
	ret = app.exec();
      
      // shut down the interpreter
      PyInterpreterState * mainInterpreterState = mainThreadState->interp;
      // create a thread state object for this thread
      PyThreadState * myThreadState = PyThreadState_New(mainInterpreterState);
      PyThreadState_Swap(myThreadState);
      
      PyEval_AcquireLock();
      Py_Finalize();
      
      return ret;
    }
    else {
      //No themes given on command line and no saved session.
      //Show welcome dialog.

      WelcomeForm* wcmFrm = new WelcomeForm(0,0,true,0);
      if (wcmFrm->exec() == QDialog::Accepted) {

	QStringList fileNames;
	
	fileNames = KFileDialog::getOpenFileNames(QString::null, "*.theme *.ctheme|Themes", 0, "Open Themes");
	for ( QStringList::Iterator it = fileNames.begin(); it != fileNames.end(); ++it )
	  {
	    QFileInfo file( *it );
	    if( file.exists() && !file.isDir() )
	      {
		mainWin = new karamba( *it , false);
		mainWin->show();
		OK = true;
	      }
	  }
	
      }
      int ret = 0;
      if( OK )
	ret = app.exec();
      
      // shut down the interpreter
      PyInterpreterState * mainInterpreterState = mainThreadState->interp;
      // create a thread state object for this thread
      PyThreadState * myThreadState = PyThreadState_New(mainInterpreterState);
      PyThreadState_Swap(myThreadState);
      PyEval_AcquireLock();
      Py_Finalize();
      return ret;
    }
    
    args->clear();

    // shut down the interpreter

    PyInterpreterState * mainInterpreterState = mainThreadState->interp;
    // create a thread state object for this thread
    PyThreadState * myThreadState = PyThreadState_New(mainInterpreterState);
    PyThreadState_Swap(myThreadState);
    PyEval_AcquireLock();
    Py_Finalize();

    return 0;



}
