---
title: Projects
---

## At the DLR

### Current Projects

- [MAVEN](http://www.maven-its.eu/) Managing Automated Vehicles
  Enhances Network
- [TransAID](https://ec.europa.eu/inea/en/horizon-2020/projects/H2020-Transport/Automated-Road-Transport/TransAID)
  new hierarchical traffic management procedures to allow the smooth
  integration of automated vehicles in traffic systems
- [VITAL](https://www.dlr.de/fs/en/desktopdefault.aspx/tabid-10704/20365_read-42579/):
  innovative traffic light control with V2X Communication.
- [VABENE](https://verkehrsforschung.dlr.de/en/projects/vabene). SUMO simulates and predicts
  large-scale traffic for disaster and public event management
- [I.MoVe](https://verkehrsforschung.dlr.de/de/projekte/imove)
  developing additional car following models
- [Urban Mobility](http://www.urmo.info/) Intermodal routing and
  modeling of transfer between vehicles in SUMO
- [Mobility Inside](http://www.mobilityinside.de/) Using SUMO's
  intermodal routing engine
- [HubChain (german)](http://komob.de/projekte/hub-chain/) simulating
  autonomous public transport in rural areas
- [MENDEL](http://mendel-projekt.de/en/home-2/) modeling electric
  buses and optimizing charging with respect to grid load

### Past Projects

- [VEU](https://www.dlr.de/VEU/). In this project, SUMO is used to
  simulated the traffic of Berlin
- [COLOMBO](https://verkehrsforschung.dlr.de/en/projects/colombo) Cooperative Self-Organizing
  System for low Carbon Mobility at low Penetration Rates
- [AMITRAN](https://web.archive.org/web/20180815190303/http://www.amitran.eu/)
- [MODUM](https://web.archive.org/web/20180831121624/http://modum-project.eu/)
- [iTetris](http://www.ict-itetris.eu/) An Integrated Wireless and
  Traffic Platform for Real-Time Road Traffic Management Solutions
- [Delphi](https://www.dlr.de/sc/desktopdefault.aspx/tabid-1262/1765_read-9581): country-wide traffic analysis and prognosis for Germany
- [ORINOKO](https://www.nuernberg.de/imperia/md/verkehrsplanung/dokumente/orinoko_final_internet.pdf): improvements on mobility in the
  city of Nürnberg
- TrafficOnline: traffic flow estimation using cellular phones
- [Soccer2006](https://web.archive.org/web/20150705081516/http://www.dlr.de/desktopdefault.aspx/tabid-1296):
  Traffic prognosis during the FIFA-WorldCup 2006
- Weltjugendtag2005: Traffic prognosis during the world youth day 2005
- [TrafficTower](https://www.dlr.de/fs/desktopdefault.aspx/tabid-1237/5441_read-12154/):
  A virtual traffic management centre
- [INVENT](http://www.invent-online.de/): Evaluation of modern traffic
  management approaches
- [OIS](https://web.archive.org/web/20040826034935/http://www.dlr.de/vf/forschung/projekte/ois): Verification of
  using optical sensors for optimization of traffic lights
- [CityMobil](https://web.archive.org/web/20191204150245/http://www.citymobil-project.eu:80/) Automatic urban
  transportation. A [simulation for a parking lot](../Tutorials/CityMobil.md) inspired by the Rome
  demonstrator is included with SUMO.
- [DRIVE C2X](https://web.archive.org/web/20170311043037/http://www.drive-c2x.eu/project) Driving implementation
  and evaluation of C2X communication technology

## At other Institutions

### Current Projects

- [MultiAgent Control of Traffic
  Signals](https://github.com/k0emt/macts)
- [VENTOS](http://maniam.github.io/VENTOS/) a VEhicular NeTwork Open
  Simulator
- [Webots](https://www.cyberbotics.com/) a 3D physics robot simulator
  connected to SUMO
- [eWorld](https://web.archive.org/web/20161205050209/http://eworld.sourceforge.net/) - an application that
  allows to convert and enrich roads networks; interaction is done via
  the [TraCI](../TraCI.md)-protocol
- [Environmental Monitoring in/of Metropolitan Areas](http://www.ibr.cs.tu-bs.de/projects/emma/index.xml?lang=en)
  by Sven Lahde, Michael Doering, Wolf-Bastian Pöttner, Moritz Rosin,
  Gerrit Lammert and Lars Wolf from the University of Braunschweig,
  Germany
- [AutoNomos - A Distributed and Self-Regulating Approach for Organizing a Large System of Mobile Objects.](https://web.archive.org/web/20180307071524/http://auto-nomos.de/) Axel Wegener, Horst Hellbrück
  and Stefan Fischer from the University of Luebeck, Germany in
  cooperation with Sándor Fekete from Braunschweig Technical
  University, Germany
- [TraNS - Traffic and Network Simulation environment for design, implementation
  and realistic evaluation of VANET
  applications](http://trans.epfl.ch)
  by Michal Piorkowski, Maxim Raya, Ada Lezama Lugo and Jean-Pierre
  Hubaux from [Laboratory for Computer Communications and Applications
  (LCA)](http://lcawww.epfl.ch), [EPFL](http://www.epfl.ch),
  Switzerland
  TraNS is the first open-source project providing a full-blown
  application-centric evaluation framework for VANETs. It has a unique
  set of features necessary to build VANET applications and evaluate
  them in realistic conditions. It comes with a set of ready to use
  examples.
  publications: [Piorkowski, Raya, Lugo, Papadimitratos, Grossglauser,
  Hubaux
  2007](../Publications.md#piorkowskirayalugopapadimitratosgrossglauserhubaux2007)
- [Veins - "Vehicles in Network Simulation"](https://veins.car2x.org/)
  by Christoph Sommer from the Department of Computer Science,
  University of Erlangen, Germany
  publications: [Sommer, Yao, German, Dressler, 2008](../Publications.md#sommeryaogermandressler2008), [Sommer,
  Yao, German, Dressler, 2008
  (2)](../Publications.md#sommeryaogermandressler2008_2)
- "Assessment of traffic regulation policies for the minimization of
  pollutants emissions"
  by Mauro Bianchi at [CEFRIEL](http://www.cefriel.it/), Italy.
  This project uses SUMO in combination with EMEP/CORINAIR methodology
  for evaluating the impact of different traffic regulation strategies
  on pollutants emissions. Traffic simulations are performed offline
  for identifying some optimal regulation policies for different local
  traffic conditions, using a simple evolutionary algorithm. We
  hypothesize an online regulation system with a network of sensors
  that is used to recognize the current traffic situations and deploy
  the optimal traffic regulation policies.
- [Fidens – Trust between Cooperative Systems in Application to VANETs](https://web.archive.org/web/20120313075112/http://www.ldv.ei.tum.de/en/research/fidens/)
  This project investigates trust in vehicular networks (VANETs).
  Besides the trust research, it features a simulation environment for
  large scale vehicular network applications. Our typical scenario
  involves about 13000 vehicles per day over 26 weeks. We build on top
  of SUMO and the network simulator Shawn.
  [Shawn](https://github.com/itm/shawn) aims on investigating an
  algorithm in a network while the underlying layers are kept well
  controlled. To do so, it simulates the effects of the underlying
  layers, not their protocols in detail. This makes it especially fast
  and suitable for application developers.

### Past Projects

- [Congestion-Aware Vehicular Traffic Routing Using WiFi Hotspots](https://www.cl.cam.ac.uk/research/dtg/www/publications/public/jjd27/ciiHandout.pdf)
  by David N. Cottingham, Jonathan J. Davies, & Alastair R. Beresford
  from the University of Cambridge, UK
  publications: [Cottingham, Davies, Beresford,
  2005](../Publications.md#cottinghamdaviesberesford2005)
- GPS-Route by Stefan Edelkamp, Shahidd Jabar and Tilman Mehrer (supervisors)
  from the University of Dortmund, Germany
  many thanks go to students who have extendended SUMO: Maik
  Drozdzynski, Andreas Gaubatz and Miguel Liebe
  publications: [Edelkamp, Jabar, Mehrer, 2005](../Publications.md#edelkampjabarmehrer2005)
- [Rapid Generation of Realistic Simulation for VANET](https://lens.csie.ncku.edu.tw/index.php/research-projects/past/18-rapid-vanet)
  by Feliz Karnadi, Zhi Hai Mo, and Kun Chan Lan from the University
  of New South Wales, Sydney, Australia
  many thanks for extending SUMO\!
  publications: [Karnadi, Mo, Lan,
  2005](../Publications.md#karnadimolan2005)
- ["iTranSIM - Simulation-based Vehicle
  Location"](https://www.cs.tcd.ie/publications/tech-reports/reports.07/TCD-CS-2007-56.pdf)
  by Tino Morenz; Master thesis; 2008
- "Analyse und Simulation von Verkettbarkeitsmaßen in pseudonymer,
  mobiler
  Kommunikation" by Clemens Honomichl; Diploma thesis; 2008
- [emil - Elektrobusse mit induktiver Ladetechnik (german only)](https://web.archive.org/web/20150722031908/http://www.verkehr-bs.de/unternehmen/forschungsprojekt-emil.html)
- [Metro Traffic Simulator](https://www.youtube.com/watch?v=P9rHo6yHRNc)

## Code repositories with SUMO related stuff

- [NetPopulate](https://github.com/maslab-ufrgs/net-populate) Demand generation for SUMO
- [C\# and ANSI C TraCI interface](https://github.com/CodingConnected/CodingConnected.Traci)
- [Integrated Framework for Mathematical Simulations (IFMS)](https://web.archive.org/web/20180611001733/https://github.com/nitindesh/IFMS)
- [Veins](https://github.com/sommer/veins)
- [Secure Cycle project established during the BCX 2018](https://github.com/kratz00/bcx18_secureCycle)
- [An open source traffic light control program](https://github.com/MartijnHarmenzon/openTLC)
- [PyPML - Python Parking Monitoring Library](https://github.com/lcodeca/PyPML)
- [SAGA](https://github.com/lcodeca/SUMOActivityGen) - An Activity-based Multi-modal Mobility Scenario Generator for SUMO.
- [RLLIB+SUMO Utils](https://github.com/lcodeca/rllibsumoutils) is a connector between the RLLIB library and SUMO that uses TraCI. It can be tested using [RLLIB+SUMO Docker](https://github.com/lcodeca/rllibsumodocker) based on a GPU-enabled official TensorFlow image.
- [DCARP-SUMO-Simulation](https://github.com/HawkTom/DCARP-SUMO-Simulation) Benchmarking Dynamic Capacitated Arc Routing Algorithms Using Real-World Traffic Simulation. There is also a [related paper](https://ieeexplore.ieee.org/abstract/document/9870399)

### Visualization related

- [Web-based 3D visualization of SUMO microsimulations using TraCI and three.js](https://github.com/sidewalklabs/sumo-web3d)
- [Unity based 3D driving simulator](https://github.com/DarraghMac97/Real-time-Traffic-Simulation-with-3D-Visualisation)
- [Unity visualization of pedestrian trajectories](https://github.com/danielbuechele/SumoVizUnity) based on a [WebGL project](https://github.com/danielbuechele/SumoViz3D)
- [SUMO3d - A partial unity 3D project for coupling SUMO and Unity3D](https://github.com/SvenMertin/SUMO3d)
- [Unity frontend for SUMO](https://github.com/Andrew-Stebel/Unity-SUMO)
- https://github.com/BMEAutomatedDrive/SUMO-Unity3D-connection
