/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.visualization.network.NetVis;
import cadyts.utilities.visualization.network.VisLinkData;
import cadyts.utilities.visualization.network.VisNetworkData;
import cadyts.utilities.visualization.network.VisNodeData;

public class OsmNetworkPreprocessor {
    private static final String LONGITUDE_ATTRIBUTE = "lon";
    private static final String LATITUDE_ATTRIBUTE = "lat";
    private double earthRadius_m = 6378137.0;
    private boolean addBiogemeLength = false;

    public void setEarthRadius_m(double earthRadius_m) {
        this.earthRadius_m = earthRadius_m;
    }

    public double getEarthRadius_m() {
        return this.earthRadius_m;
    }

    public void setAddBiogemeLength(boolean addBiogemeLength) {
        this.addBiogemeLength = addBiogemeLength;
    }

    public boolean getAddBiogemeLength() {
        return this.addBiogemeLength;
    }

    private double length(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public VisNetworkData newVisData(Network network) {
        VisNetworkData result = new VisNetworkData();
        double minLon = Double.POSITIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        for (Node node : network.getNodes()) {
            minLon = Math.min(minLon, Double.parseDouble(node.getAttr(LONGITUDE_ATTRIBUTE)));
            minLat = Math.min(minLat, Double.parseDouble(node.getAttr(LATITUDE_ATTRIBUTE)));
        }
        double minEasting = Double.POSITIVE_INFINITY;
        double maxEasting = Double.NEGATIVE_INFINITY;
        double minNorthing = Double.POSITIVE_INFINITY;
        double maxNorthing = Double.NEGATIVE_INFINITY;
        for (Node node : network.getNodes()) {
            double easting = this.earthRadius_m * (Double.parseDouble(node.getAttr(LONGITUDE_ATTRIBUTE)) - minLon) * Math.PI / 180.0;
            double northing = this.earthRadius_m * (Double.parseDouble(node.getAttr(LATITUDE_ATTRIBUTE)) - minLat) * Math.PI / 180.0;
            VisNodeData nodeData = result.getVisNodeData(node);
            nodeData.setEasting(easting);
            nodeData.setNorthing(northing);
            minEasting = Math.min(minEasting, easting);
            maxEasting = Math.max(maxEasting, easting);
            minNorthing = Math.min(minNorthing, northing);
            maxNorthing = Math.max(maxNorthing, northing);
        }
        result.setMinEasting(minEasting);
        result.setMaxEasting(maxEasting);
        result.setMinNorthing(minNorthing);
        result.setMaxNorthing(maxNorthing);
        for (Link link : network.getLinks()) {
            Node from = link.getFromNode();
            Node to = link.getToNode();
            VisLinkData linkData = result.getVisLinkData(link);
            VisNodeData fromNodeData = result.getVisNodeData(from);
            VisNodeData toNodeData = result.getVisNodeData(to);
            linkData.setLength_m(this.length(fromNodeData.getEasting(), fromNodeData.getNorthing(), toNodeData.getEasting(), toNodeData.getNorthing()));
            linkData.setLanes(1);
            linkData.setVisible(true);
            linkData.setTransform(NetVis.newLinear2PlaneTransform(link, fromNodeData, toNodeData, linkData.getLength_m()));
        }
        return result;
    }
}

