/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Pair;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import trafficdefinition.TrafficDefinitionLayer;

public class ExportLayersTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6606926480332673298L;
    List<Pair<TrafficDefinitionLayer, Boolean>> data;

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Export";
        }
        return "Layer name";
    }

    public ExportLayersTableModel(List<Pair<TrafficDefinitionLayer, Boolean>> data) {
        this.data = data;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col < 0 || col > 1 || row < 0 || row > this.data.size() - 1) {
            return null;
        }
        if (col == 0) {
            return this.data.get(row).getSecond();
        }
        return this.data.get(row).getFirst().getName();
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return Boolean.class;
        }
        if (c == 1) {
            return String.class;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.data.get(row).setSecond((Boolean)value);
        }
        this.fireTableCellUpdated(row, col);
    }
}

