/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.utilities.visualization.network.RendererA;
import cadyts.utilities.visualization.network.VisConfig;
import cadyts.utilities.visualization.network.VisNetworkData;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class NetJComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final double BORDER_FACTOR = 0.0;
    private final VisNetworkData netData;
    private RendererA networkRenderer;
    private int frameDefaultWidth;
    private int frameDefaultHeight;
    private VisConfig visconfig;
    private double viewMinX;
    private double viewMinY;
    private double viewMaxX;
    private double viewMaxY;

    public void setViewClipCoords(double minX, double minY, double maxX, double maxY) {
        this.viewMinX = this.networkClippingMinEasting() + minX * this.networkClippingWidth();
        this.viewMaxX = this.networkClippingMinEasting() + maxX * this.networkClippingWidth();
        this.viewMinY = this.networkClippingMinNorthing() + (1.0 - maxY) * this.networkClippingHeight();
        this.viewMaxY = this.networkClippingMinNorthing() + (1.0 - minY) * this.networkClippingHeight();
    }

    public void moveViewClipCoords(double deltaX, double deltaY) {
        this.viewMinX += deltaX * this.networkClippingWidth();
        this.viewMaxX += deltaX * this.networkClippingWidth();
        this.viewMinY -= deltaY * this.networkClippingHeight();
        this.viewMaxY -= deltaY * this.networkClippingHeight();
    }

    public int checkViewClip(double x, double y) {
        int xquart;
        int n = x < this.viewMinX ? 0 : (xquart = x > this.viewMaxX ? 2 : 1);
        int yquart = y < this.viewMinY ? 0 : (y > this.viewMaxY ? 2 : 1);
        return xquart + 4 * yquart;
    }

    public boolean checkLineInClip(double sx, double sy, double ex, double ey) {
        int qend;
        int qstart = this.checkViewClip(sx, sy);
        if (qstart == (qend = this.checkViewClip(ex, ey)) && qstart != 5) {
            return false;
        }
        if (qstart % 4 == qend % 4 && qstart % 4 != 1) {
            return false;
        }
        return qstart / 4 != qend / 4 || qstart / 4 == 1;
    }

    public NetJComponent(RendererA networkRenderer, VisConfig visconfig, VisNetworkData netData) {
        this.netData = netData;
        this.networkRenderer = networkRenderer;
        this.visconfig = visconfig;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double factor = screenSize.getWidth() / this.networkClippingWidth();
        factor = Math.min(factor, screenSize.getHeight() / this.networkClippingHeight());
        this.frameDefaultWidth = (int)Math.floor(this.networkClippingWidth() * (factor *= (double)0.8f));
        this.frameDefaultHeight = (int)Math.floor(this.networkClippingHeight() * factor);
        this.scale(1.0);
        this.setViewClipCoords(0.0, 0.0, 1.0, 1.0);
    }

    public void scale(double factor) {
        if (factor > 0.0) {
            int scaledWidth = (int)Math.round(factor * (double)this.frameDefaultWidth);
            int scaledHeight = (int)Math.round(factor * (double)this.frameDefaultHeight);
            this.setPreferredSize(new Dimension(scaledWidth, scaledHeight));
        }
    }

    private double additionalBorder() {
        return 0.1 * Math.max(this.netData.getMaxEasting() - this.netData.getMinEasting(), this.netData.getMaxNorthing() - this.netData.getMinNorthing());
    }

    private double networkClippingEastingBorder() {
        return Math.max(1.0, 0.0 * (this.netData.getMaxEasting() - this.netData.getMinEasting())) + this.additionalBorder();
    }

    private double networkClippingNorthingBorder() {
        return Math.max(1.0, 0.0 * (this.netData.getMaxNorthing() - this.netData.getMinNorthing())) + this.additionalBorder();
    }

    private double networkClippingMinEasting() {
        return this.netData.getMinEasting() - this.networkClippingEastingBorder();
    }

    private double networkClippingMaxEasting() {
        return this.netData.getMaxEasting() + this.networkClippingEastingBorder();
    }

    private double networkClippingMinNorthing() {
        return this.netData.getMinNorthing() - this.networkClippingNorthingBorder();
    }

    private double networkClippingMaxNorthing() {
        return this.netData.getMaxNorthing() + this.networkClippingNorthingBorder();
    }

    private double networkClippingWidth() {
        return this.networkClippingMaxEasting() - this.networkClippingMinEasting();
    }

    private double networkClippingHeight() {
        return this.networkClippingMaxNorthing() - this.networkClippingMinNorthing();
    }

    private AffineTransform getBoxTransform() {
        double v1 = this.networkClippingMinEasting();
        double w1 = this.networkClippingMinNorthing();
        double v2 = this.networkClippingMaxEasting();
        double w2 = this.networkClippingMaxNorthing();
        Dimension prefSize = this.getPreferredSize();
        double x1 = 0.0;
        double y1 = (int)prefSize.getHeight();
        double x2 = (int)prefSize.getWidth();
        double y2 = 0.0;
        double m00 = (x1 - x2) / (v1 - v2);
        double m02 = x1 - m00 * v1;
        double m11 = (y1 - y2) / (w1 - w2);
        double m12 = y1 - m11 * w1;
        return new AffineTransform(m00, 0.0, 0.0, m11, m02, m12);
    }

    public Point2D.Double getNetCoord(double x, double y) {
        Point2D.Double result = new Point2D.Double();
        Dimension prefSize = this.getPreferredSize();
        result.x = x / (double)prefSize.width;
        result.y = 1.0 - y / (double)prefSize.height;
        result.x *= this.netData.getMaxEasting() - this.netData.getMinEasting();
        result.y *= this.netData.getMaxNorthing() - this.netData.getMinNorthing();
        result.x += this.netData.getMinEasting();
        result.y += this.netData.getMinNorthing();
        return result;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.visconfig.getUseAntiAliasing()) {
            g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        } else {
            g2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
        }
        this.networkRenderer.render(g2, this.getBoxTransform());
    }
}

