#include "Document.h"
#include "SubtitleSubRip.h"
#include "SubtitleMicroDVD.h"
#include "SubtitleTTXT.h"
#include "SubtitleMPL2.h"
#include "SubtitleASS.h"
#include "SubtitleSSA.h"
#include "SubtitleSubViewer2.h"
#include "SubtitleMPsub.h"

#include "ISubtitleEditor.h"

#include <cppunit/extensions/HelperMacros.h>

class testSubtitleLoaders : public CppUnit::TestFixture
{
	CPPUNIT_TEST_SUITE( testSubtitleLoaders );
	CPPUNIT_TEST( testASS );
	CPPUNIT_TEST( testSSA );
	CPPUNIT_TEST( testMicroDVD );
	CPPUNIT_TEST( testMPL2 );
	CPPUNIT_TEST( testMPsub );
	CPPUNIT_TEST( testSubRip );
	CPPUNIT_TEST( testSubViewer2 );
	CPPUNIT_TEST_SUITE_END();
public:

	void setUp()
	{
	}

	void tearDown()
	{
	}

	void testASS()
	{
		Document doc;
		SubtitleASS fmt(&doc);

		CPPUNIT_ASSERT(doc.open("test/ass.format"));
	}

	void testSSA()
	{
		Document doc;
		SubtitleSSA fmt(&doc);

		CPPUNIT_ASSERT(doc.open("test/ssa.format"));
	}

	void testMicroDVD()
	{
		Document doc;
		SubtitleMicroDVD fmt(&doc);

		CPPUNIT_ASSERT(doc.open("test/microdvd.format"));
	}

	void testMPL2()
	{
		Document doc;
		SubtitleMPL2 fmt(&doc);

		CPPUNIT_ASSERT(doc.open("test/mpl2.format"));
	}

	void testMPsub()
	{
		Document doc;
		SubtitleMPsub fmt(&doc);

		CPPUNIT_ASSERT(doc.open("test/mpsub.format"));
	}

	void testSubRip()
	{
		Document doc;
		SubtitleSubRip fmt(&doc);

		CPPUNIT_ASSERT(doc.open("test/subrip.format"));
	}

	void testSubViewer2()
	{
		Document doc;
		SubtitleSubViewer2 fmt(&doc);

		CPPUNIT_ASSERT(doc.open("test/subviewer2.0.format"));
	}
};

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION(testSubtitleLoaders);

