#ifndef _SubtitleTime_h
#define _SubtitleTime_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <math.h>
#include <string>
#include <glibmm/ustring.h>

/**
 *
**/
class SubtitleTime
{
public:
	SubtitleTime();
	
	/*
	 *
	 */
	SubtitleTime(const long &total_msecs);

	/*
	 *	ex : "0:10:50.600"
	 */
	//SubtitleTime(const std::string &srt);
	SubtitleTime(const Glib::ustring &srt);
	
	/*
	 *
	 */
	SubtitleTime(const int &h, const int &m, const int &s, const int &ms);

	void set(const int &h, const int &m, const int &s, const int &ms);
	void initTotalMSecs();

	void move(long msecs);

	SubtitleTime operator-(const SubtitleTime &b) const;
	SubtitleTime operator+(const SubtitleTime &b) const;
	SubtitleTime operator*(const double &mult) const;
	double operator/(const SubtitleTime &b) const;

	bool operator==(const SubtitleTime &time);
	bool operator!=(const SubtitleTime &time);
	bool operator>(const SubtitleTime &time);
	bool operator>=(const SubtitleTime &time);
	bool operator<(const SubtitleTime &time);
	bool operator<=(const SubtitleTime &time);


	Glib::ustring str() const;

	/*
	 *	valide le format du temps
	 *	h:mm:ss.ms
	 */
	static bool validate(const Glib::ustring &str);

	/*
	 *	return "0:00:00.000"
	 */
	static Glib::ustring null();

	/*
	 *	calcul le temps à partir d'une frame et d'un framerate
	 *	ex: (450, 23.976)
	 */
	static SubtitleTime frame_to_time(const long int& frame, const float& framerate);

	/*
	 *
	 */
	static long int time_to_frame(const SubtitleTime& time, const float& framerate);

public:
	int		hours;
	int		mins;
	int		secs;
	int		msecs;
	long	totalmsecs;
};


/**
 *	return hours:mins:secs,msecs
**/
std::string getTime2String(const SubtitleTime &time);

/**
 *
**/
long getMSecs(const SubtitleTime &time);

/**
 *
**/
SubtitleTime getTime2MSecs(const long &total);

#endif//_SubtitleTime_h
