#ifndef _SubtitleModifier_h
#define _SubtitleModifier_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "SubtitleModel.h"

/*
 *	Cette class fonctionne avec un iterator (SubtitleModel).
 *	Elle permet de modifier les attributs de l'iter
 *	il est possible de modifier directement l'iter mais
 *	dans le cas ou on modifie par exemple le temps "end"
 *	il faut aussi modifier le temps "duration", etc...
 *
 *	Passer par cette class evite les oublies de ce genre.
 *
 *  /!\	
 *  La durée de vie d'un SubtitleModifier est la même que l'iter!
 *  On ne verifie pas la validiter des arguments! (pour les performances)
 */
class SubtitleModifier
{
public:
	SubtitleModifier();
	SubtitleModifier(const Gtk::TreeIter &iter);
	~SubtitleModifier();

	/*
	 * valide ?
	 */
	operator bool() const;

	/*
	 *	init avec l'iterator
	 */
	void init(const Gtk::TreeIter &iter);


	/*
	 *
	 */
	Gtk::TreeIter get_iter() const;


	/*
	 *
	 */
	void set_num(unsigned int num);

	/*
	 *
	 */
	unsigned int get_num() const;


	/*
	 *
	 */
	void set_layer(const Glib::ustring &layer);

	/*
	 *
	 */
	Glib::ustring get_layer() const;

	/*
	 *	petite optimisation qui permet de calculer 
	 *	qu'une seule fois duration
	 */
	void set_start_and_end(const SubtitleTime &start, const SubtitleTime &end);

	/*
	 *
	 */
	void set_start(const Glib::ustring &time);
	void set_start(const SubtitleTime &time);

	/*
	 *
	 */
	SubtitleTime get_start() const;


	/*
	 *
	 */
	void set_end(const Glib::ustring &time);
	void set_end(const SubtitleTime &time);

	/*
	 *
	 */
	SubtitleTime get_end() const;


	/*
	 *
	 */
	void set_duration(const Glib::ustring &time);
	void set_duration(const SubtitleTime &time);

	/*
	 *
	 */
	SubtitleTime get_duration() const;


	/*
	 *
	 */
	void set_style(const Glib::ustring &style);

	/*
	 *
	 */
	Glib::ustring get_style() const;


	/*
	 *
	 */
	void set_name(const Glib::ustring &name);

	/*
	 *
	 */
	Glib::ustring get_name() const;
	
	
	/*
	 *
	 */
	void set_margin_l(const Glib::ustring &value);
	void set_margin_r(const Glib::ustring &value);
	void set_margin_v(const Glib::ustring &value);

	/*
	 *
	 */
	Glib::ustring get_margin_l() const;
	Glib::ustring get_margin_r() const;
	Glib::ustring get_margin_v() const;


	/*
	 *
	 */
	void set_effect(const Glib::ustring &effect);

	/*
	 *
	 */
	Glib::ustring get_effect() const;


	/*
	 *
	 */
	void set_text(const Glib::ustring &text);

	/*
	 *
	 */
	Glib::ustring get_text() const;


	/*
	 *
	 */
	void set_translation(const Glib::ustring &text);

	/*
	 *
	 */
	Glib::ustring get_translation() const;

	/*
	 *	ex: 6 or 3/3
	 */
	Glib::ustring get_characters_per_line();

protected:
	static SubtitleColumnRecorder column;
	Gtk::TreeIter iter;
};


#endif//_SubtitleModifier_h
