#ifndef _StyleModel_h
#define _StyleModel_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <gtkmm/liststore.h>
#include "Color.h"

/*
 *
 */
class StyleColumnRecorder : public Gtk::TreeModel::ColumnRecord
{
public:
	StyleColumnRecorder()
	{
		add(name);
		add(font_name);
		add(font_size);

		add(primary_colour);
		add(secondary_colour);
		add(outline_colour);	// outline_color
		add(shadow_colour);		// shadow

		add(bold);
		add(italic);
		add(underline);
		add(strikeout);

		add(scale_x);		// percent
		add(scale_y);		// percent
		add(spacing);		// pixel
		add(angle);			// degrees

		add(border_style);	// 1=Outline + drop shadow, 3=Opaque box
		add(outline);			// if border_style is 1,	0,1,2,3 or 4
		add(shadow);			// if border_style is 1
		// TODO : check field 13 style+
		add(alignment);		// 1=left, 2=centered, 3=right, 4=toptitle, 8=midtitle, 5=left-justified toptitle

		add(margin_l);
		add(margin_r);
		add(margin_v);
		// TODO > not present in ASS
		add(alpha_level);
		add(encoding);	
	}
public:

#define data(type,name) Gtk::TreeModelColumn<type> name;
	
	data(Glib::ustring,		name);
	data(Glib::ustring,		font_name);
	data(double,					font_size);
	
	data(Color,		primary_colour);
	data(Color,		secondary_colour);
	data(Color,		outline_colour);	// outline_color
	data(Color,		shadow_colour);		// shadow

	data(bool,						bold);
	data(bool,						italic);
	data(bool,						underline);
	data(bool,						strikeout);
	
	data(unsigned int,		scale_x);		// percent
	data(unsigned int,		scale_y);		// percent
	data(unsigned int,		spacing);		// pixel
	data(unsigned int,		angle);			// degrees
	
	data(unsigned int,		border_style);	// 1=Outline + drop shadow, 3=Opaque box
	data(unsigned int,		outline);			// if border_style is 1,	0,1,2,3 or 4
	data(unsigned int,		shadow);			// if border_style is 1
	// TODO : check field 13 style+
	data(unsigned int,		alignment);		// 1=left, 2=centered, 3=right, 4=toptitle, 8=midtitle, 5=left-justified toptitle

	data(unsigned int,		margin_l);
	data(unsigned int,		margin_r);
	data(unsigned int,		margin_v);
	// TODO > not present in ASS
	data(int,							alpha_level);
	data(int,							encoding);
#undef data
};

/*
 *
 */
class StyleModel : public Gtk::ListStore
{
public:
	StyleModel();

	Gtk::TreeIter append();

	/*
	 *	retourne une copy de iter
	 */
	Gtk::TreeIter copy(Gtk::TreeIter iter);

	/*
	 *	copy src dans this
	 */
	void copy(Glib::RefPtr<StyleModel> src);
public:
	StyleColumnRecorder m_column;
};

#endif//_StyleModel_h
