#include "utility.h"
#include <string>
#include <glibmm.h>
#include <iostream>
#include <gtkmm/messagedialog.h>

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
#ifdef __DEBUG_MSG

void __debug_msg(const char *pretty_function, const char *format, ...)
{
	va_list args;
	char *formatted = NULL, *str = NULL;

	va_start(args, format);
	formatted = g_strdup_vprintf(format, args);
	va_end(args);

	str = g_strdup_printf("MARK: %s [%s] %s", g_get_prgname(), pretty_function, formatted);
	g_free(formatted);

	std::cerr << str << std::endl;

	access(str, F_OK);
	g_free(str);
}

#endif
*/
Glib::ustring message(const char *format, ...)
{
	Glib::ustring res;
	
	va_list args;
	char *formatted = NULL;

	va_start(args, format);
	formatted = g_strdup_vprintf(format, args);
	va_end(args);

	res = formatted;
	
	g_free(formatted);

	return res;
}

void debug(const gchar *key, const Glib::ustring &msg)
{
	std::cerr << "LOG [" << key << "] >> " << msg << std::endl;
}


static gchar* encodings [] = {
	"ISO-8859-1",
	"ISO-8859-2",
	"ISO-8859-3",
	"ISO-8859-4",
	"ISO-8859-5",
	"ISO-8859-6",
	"ISO-8859-7",
	"ISO-8859-8",
	"ISO-8859-8-I",
	"ISO-8859-9",
	"ISO-8859-10",
	"ISO-8859-13",
	"ISO-8859-14",
	"ISO-8859-15",
	"ISO-8859-16",
	
	"UTF-7",
	"UTF-16",
	"UCS-2",
	"UCS-4",
	
	"ARMSCII-8",
	"BIG5",
	"BIG5-HKSCS",
	"CP866",
	
	"EUC-JP",
	"EUC-KR",
	"EUC-TW",
	
	"GB18030",
	"GB2312",
	"GBK",
	"GEORGIAN-ACADEMY",
	"HZ",
	
	"IBM850",
	"IBM852",
	"IBM855",
	"IBM857",
	"IBM862",
	"IBM864",
	
	"ISO-2022-JP",
	"ISO-2022-KR",
	"ISO-IR-111",
	"JOHAB",
	"KOI8R",
	"KOI8-R",
	"KOI8U",
	
	"SHIFT_JIS",
	"TCVN",
	"TIS-620",
	"UHC",
	"VISCII",
	
	"WINDOWS-1250",
	"WINDOWS-1251",
	"WINDOWS-1252",
	"WINDOWS-1253",
	"WINDOWS-1254",
	"WINDOWS-1255",
	"WINDOWS-1256",
	"WINDOWS-1257",
	"WINDOWS-1258"
};


/*
 *
 */
bool check_end_char(const gchar c)
{
	switch(c)
	{
	case '\0':
	case '\t':
	case '\015':
	case '\n':
		return true;
	default:
	 return false;
	}
	return false;
}


/*
 *
 */
Glib::ustring check_end_char(const Glib::ustring &str)
{
	Glib::ustring::size_type pos = str.find('\015');
	if(pos != Glib::ustring::npos)
		return str.substr(0, pos);
	return str;
}


/*
 *
 */
Glib::ustring get_share_dir(const Glib::ustring &file)
{
	Glib::ustring filename;
	
	filename = Glib::build_filename(PACKAGE_SHARE_DIR, file);

	if(Glib::file_test(filename, Glib::FILE_TEST_EXISTS))
		return filename;
	// utiliser pour le dev 
	filename = Glib::build_filename("share", file);

	if(Glib::file_test(filename, Glib::FILE_TEST_EXISTS))
		return filename;
	//
	std::cerr << "get_share_dir not found:" << file << std::endl;
	return "";
}

/*
 *
 */
void find_and_replace(Glib::ustring &text, const Glib::ustring &find, const Glib::ustring &replace)
{
	Glib::ustring::size_type pos = 0;
	
	while((pos = text.find(find, pos)) != Glib::ustring::npos)
	{
		text.replace(pos, find.size(), replace);
	}
}


void dialog_warning(const Glib::ustring &primary_text, const Glib::ustring &secondary_text)
{
	Glib::ustring msg;

	msg += "<span weight=\"bold\" size=\"larger\">";
	msg += primary_text;
	msg += "</span>\n\n";
	msg += secondary_text;

	Gtk::MessageDialog dialog(msg, true, Gtk::MESSAGE_WARNING, Gtk::BUTTONS_OK, true);
	dialog.run();
}


void dialog_error(const Glib::ustring &primary_text, const Glib::ustring &secondary_text)
{
	Glib::ustring msg;

	msg += "<span weight=\"bold\" size=\"larger\">";
	msg += primary_text;
	msg += "</span>\n\n";
	msg += secondary_text;

	Gtk::MessageDialog dialog(msg, true, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
	dialog.run();
}




RegEx::RegEx(const std::string &ex, int flag)
{
	m_err = regcomp(&m_rx, ex.c_str(), flag);//REG_EXTENDED | REG_NEWLINE/* | REG_NOSUB*/);
	if(m_err != 0)
	{
		std::cerr << "RegEx::comp error :" << ex << std::endl;
	}
}

RegEx::~RegEx()
{
	regfree(&m_rx);
}

bool RegEx::exec(const std::string &string)
{
	if(m_err != 0)
		return false;

	if(regexec(&m_rx, string.c_str(), 0, NULL, 0) == 0)
		return true;

	return false;
}

bool RegEx::exec(const std::string &string, std::string::size_type &start, std::string::size_type &len)
{
	if(m_err != 0)
		return false;

	size_t nmatch = 0;
	regmatch_t *pmatch = NULL;

	nmatch = m_rx.re_nsub+1;
	pmatch = new regmatch_t[nmatch];

	if(regexec(&m_rx, string.c_str(), nmatch, pmatch, 0) == 0)
	{
		int _start = pmatch[0].rm_so;
		int _end = pmatch[0].rm_eo;

		start = _start;
		len = _end - _start;

		delete [] pmatch;

		return true;
	}

	delete [] pmatch;

	return false;
}

