/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "SubtitleMPsub.h"
#include <iostream>
#include <fstream>
#include <glibmm/ustring.h>
#include "utility.h"

/*
 *
 */
Glib::ustring SubtitleMPsub::get_name()
{
	return "MPsub";
}

/*
 *
 */
Glib::ustring SubtitleMPsub::get_extension()
{
	return "sub";
}

/*
 *
 */
bool SubtitleMPsub::check(const std::string &line)
{
	static RegEx ex("^FORMAT=(TIME|[0-9])");	
	return ex.exec(line);
}


/*
 *
 */
SubtitleMPsub::SubtitleMPsub(Document* doc)
:m_model(doc->m_subtitleModel)
{
}

/*
 *
 */
SubtitleMPsub::~SubtitleMPsub()
{
}


/*
 *
 */
bool SubtitleMPsub::open(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	SubtitleFormat::open(filename, encoding);

	debug_msg("SubtitleMPsub::open > start");
	
	std::ifstream file(filename.c_str());
	
	//file.imbue(std::locale("C"));

	if(!file)
	{
		throw SubtitleException("SubtitleMPsub", _("I can't open this file."));
	}

	SubtitleColumnRecorder column;

	SubtitleTime old_start, old_end;

	float start=0, end=0;

	bool use_time = false;

	int d = 0; // FORMAT=%d
	float multiplier = 1.;

//    mpsub_multiplier = (uses_time ? 100.0 : 1.0);
//    
	std::string line;
	while(!file.eof() && std::getline(file, line))
	{
		if(std::sscanf(line.c_str(), "%f %f", &start, &end) == 2)
		{
			// fuck ! fixme numeric error
			std::istringstream iss(line);
			iss >> start;
			iss >> end;

			SubtitleTime t_start = old_end + SubtitleTime((start*multiplier));
			SubtitleTime t_end = t_start + SubtitleTime((end*multiplier));

			Glib::ustring text;
			int count = 0;

			while(std::getline(file, line))
			{
				line = check_end_char(charset_to_utf8(line));
				if(line.size() == 0)
					break;
				else
				{
					if(count > 0)
						text += "|";

					text += line;
					++count;
				}
			}
			//
			Gtk::TreeIter iter = m_model->append();

			(*iter)[column.start] = t_start.str();
			(*iter)[column.end] = t_end.str();
			(*iter)[column.text]	= text;


			old_end = t_end;
		}
		else if(std::sscanf(line.c_str(), "FORMAT=%d", &d) == 1)
		{
			multiplier = d;
		}
		else if(line.find("FORMAT=TIME") != std::string::npos)
		{
			use_time = true;
			multiplier = 1000;
		}
	}

	file.close();

	debug_msg("SubtitleMPsub::open > finish");
	return true;
}

/*
 *
 */
bool SubtitleMPsub::save(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	debug_msg("SubtitleMPsub::save > start");

	SubtitleFormat::save(filename, encoding);
	
	std::ofstream file(filename.c_str());
	if(!file)
	{
		throw SubtitleException("SubtitleMPsub", _("I can't open this file."));
	}

	file << "FORMAT=TIME" << std::endl;
	file << utf8_to_charset("# This script is create by subtitleeditor ") << utf8_to_charset(VERSION) << std::endl;
	file << utf8_to_charset("# http://kitone.free.fr/subtitleeditor/") << std::endl << std::endl;

	
	SubtitleColumnRecorder column;
	
	Glib::ustring text;
	
	SubtitleTime old_end;

	Gtk::TreeNodeChildren rows = m_model->children();
	for(Gtk::TreeIter it = rows.begin(); it; ++it)
	{
		SubtitleTime start((*it)[column.start]);
		SubtitleTime end((*it)[column.end]);

		text = (*it)[column.text];

		Glib::ustring::size_type pos=0;

		while((pos = text.find('|', pos)) != Glib::ustring::npos)
		{
			text.replace(pos, 1, "\n");
		}

		double s = (double)((start - old_end).totalmsecs) * 0.001;
		double e = (double)((end - start).totalmsecs) * .001;

		file << s << " " << e << std::endl;
		file << utf8_to_charset(text) << std::endl;
		file << std::endl;

		old_end = end;
	}
	
	file.close();

	debug_msg("SubtitleMPsub::save > finish");
	return true;
}




