/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "SubtitleMPL2.h"
#include <iostream>
#include <fstream>
#include <glibmm/ustring.h>
#include "utility.h"

/*
 *
 */
Glib::ustring SubtitleMPL2::get_name()
{
	return "MPL2";
}

/*
 *
 */
Glib::ustring SubtitleMPL2::get_extension()
{
	return "txt";
}

/*
 *
 */
bool SubtitleMPL2::check(const std::string &line)
{
	static RegEx ex("^\\[[0-9]+\\]\\[[0-9]+\\]");

	return ex.exec(line);
}


/*
 *
 */
SubtitleMPL2::SubtitleMPL2(Document* doc)
:m_model(doc->m_subtitleModel)
{
}

/*
 *
 */
SubtitleMPL2::~SubtitleMPL2()
{
}


/*
 *
 */
bool SubtitleMPL2::open(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	SubtitleFormat::open(filename, encoding);

	debug_msg("SubtitleMPL2::open > start");
	
	std::ifstream file(filename.c_str());
	if(!file)
	{
		throw SubtitleException("SubtitleMPL2", _("I can't open this file."));
	}

	SubtitleColumnRecorder column;

	unsigned int start=0, end=0;

	//double ds = SubtitleTime(0,0,0,100).totalmsecs;
	double ds = 100;
	
	std::string line;
	while(!file.eof() && std::getline(file, line))
	{
		if(sscanf(line.c_str(), "[%d][%d]", &start, &end) > 0)
		{
			std::string::size_type a = line.find(']');
			std::string::size_type b = line.find(']', a+1);
			
			std::string text = line.substr(b+1, line.size());

			Gtk::TreeIter iter = m_model->append();

			(*iter)[column.text]	= check_end_char(charset_to_utf8(text));


			(*iter)[column.start] = SubtitleTime((long int)(start*ds)).str();
			(*iter)[column.end] = SubtitleTime((long int)(end*ds)).str();
		}
	}

	file.close();

	debug_msg("SubtitleMPL2::open > finish");
	return true;
}

/*
 *
 */
bool SubtitleMPL2::save(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	debug_msg("SubtitleMPL2::save > start");

	SubtitleFormat::save(filename, encoding);
	
	std::ofstream file(filename.c_str());
	if(!file)
	{
		throw SubtitleException("SubtitleMPL2", _("I can't open this file."));
	}

	// TODO : change!
	double ds = 100;
	
	SubtitleColumnRecorder column;
	Glib::ustring text;
	
	Gtk::TreeNodeChildren rows = m_model->children();
	for(Gtk::TreeIter it = rows.begin(); it; ++it)
	{
		SubtitleTime start((*it)[column.start]);
		SubtitleTime end((*it)[column.end]);

		std::string text = utf8_to_charset((*it)[column.text]);

		//find_and_replace(text, "\n", "|");
		//find_and_replace(text, "\N", "|");
		
		file << "["
			<< (unsigned int)(start.totalmsecs / ds)
			<< "]["
			<< (unsigned int)(end.totalmsecs / ds)
			<< "]"
			<< text
			<< std::endl;
	}
	
	file.close();

	debug_msg("SubtitleMPL2::save > finish");
	return true;
}

