#ifdef ENABLE_ASPELL

#ifndef _SpellDialog_h
#define _SpellDialog_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <gtkmm/dialog.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treestore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/label.h>
#include <gtkmm/entry.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/separator.h>
#include <gtkmm/window.h>
#include <gtkmm/comboboxtext.h>
#include <gtkmm/separator.h>

#include <libglademm/xml.h>

#include "ASpell.h"
#include "Document.h"




class CurrentWord
{
public:
	unsigned int		position_start;
	unsigned int		position_next_word;

	Glib::ustring		text;
	Glib::ustring		word;
	Gtk::TreeIter		iter;

	bool next_word();
	bool next_line();

	void reset();

	void replace(const Glib::ustring &wrd);
};



class SpellColumn : public Gtk::TreeModel::ColumnRecord
{
public:
	SpellColumn()
	{
		add(string);
	}

	Gtk::TreeModelColumn<Glib::ustring>	string;
};

class SpellModel : public Gtk::ListStore
{
public:
	SpellModel()
	{
		set_column_types(m_column);
	}

	void add(const Glib::ustring &str)
	{
		Gtk::TreeIter iter = append();
		(*iter)[m_column.string] = str;
	}

	SpellColumn m_column;
};

class SpellView : public Gtk::TreeView
{
public:
	SpellView()
	{
		m_model = Glib::RefPtr<SpellModel>(new SpellModel);
		set_model(m_model);

		Gtk::TreeViewColumn *column = NULL;
		Gtk::CellRendererText *renderer = NULL;

		column = manage(new Gtk::TreeViewColumn("Suggestions"));
		renderer = manage(new Gtk::CellRendererText);
	
		column->pack_start(*renderer, false);
		column->add_attribute(renderer->property_text(), m_column.string);
	
		append_column(*column);
	}
//protected:
	SpellColumn				m_column;
	Glib::RefPtr<SpellModel>	m_model;
};

class SpellDialog : public Gtk::Dialog
{
public:
	SpellDialog();

	void execute(const Glib::RefPtr<SubtitleModel> &model);

	typedef enum ACTION
	{
		START,
		SET_LINE,	// affiche la ligne editer avec le mot select
		NEXT_WORD,	// mot suivant
		NEXT_LINE,	// line suivant
		CHECK_WORD,	// verifie le mot en cour
		REPLACE,	// remplace le mot 
		IGNORE,	// ignore ce mot
		IGNORE_ALL,	// toujours ignorer ce mot
		ADD_WORD,	// ajoute ce mot au dico
	
		CLOSE
	};

	void callback(ACTION rep);
	bool action(ACTION rep);

	bool set(Gtk::TreeIter &iter);
protected:

	void createLine();
	void createTreeViewAndButton();

	void on_selection_changed();
	void on_entry_replace_with_changed();
	void on_combobox_dics_changed();
protected:

	bool m_finish;
	Glib::RefPtr<SubtitleModel> current_model;

	CurrentWord current;

	ASpell			m_spell;
	Gtk::Entry	*m_entryText; // current line edit
	SpellView		*m_spellView;
	Gtk::Entry	*m_entryReplaceWith;

	Gtk::ComboBoxText *m_comboboxDicts;

	Gtk::Button *m_buttonNextWord;
	Gtk::Button *m_buttonReplace;
	Gtk::Button *m_buttonIgnore;
	Gtk::Button *m_buttonIgnoreAll;
	Gtk::Button *m_buttonAddWord;
};





/*
 *
 */
class DialogSpellCheck : public Gtk::Dialog
{
public:
	DialogSpellCheck(BaseObjectType *cobject, const Glib::RefPtr<Gnome::Glade::Xml> & refGlade);

	void init(Document *doc);

protected:
	
	typedef enum ACTION
	{
		START,
		SET_LINE,	// affiche la ligne editer avec le mot select
		NEXT_WORD,	// mot suivant
		NEXT_LINE,	// line suivant
		CHECK_WORD,	// verifie le mot en cour
		REPLACE,	// remplace le mot 
		IGNORE,	// ignore ce mot
		IGNORE_ALL,	// toujours ignorer ce mot
		ADD_WORD,	// ajoute ce mot au dico
	
		CLOSE
	};
	
	void createTreeView();

	bool set(Gtk::TreeIter &iter);
	void action(ACTION rep);
	
	void on_selection_changed();
	void on_entry_replace_with_changed();
	void on_combo_dicts_changed();

protected:
	ASpell			m_spell;

	CurrentWord current;

	Gtk::Entry*				m_entryText;
	Gtk::TreeView*		m_treeview;
	Gtk::Entry*				m_entryReplaceWith;

	Gtk::ComboBoxText*	m_comboDicts;
	Gtk::Button*			m_buttonReplace;
	Gtk::Button*			m_buttonIgnore;
	Gtk::Button*			m_buttonIgnoreAll;
	Gtk::Button*			m_buttonNextLine;
	Gtk::Button*			m_buttonAddWord;

	Glib::RefPtr<SpellModel> m_word_model;

	Glib::RefPtr<SubtitleModel> current_model;
};

#endif//_SpellDialog_h

#endif//ENABLE_ASPELL
