/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "DialogStyleEditor.h"
#include "utility.h"
#include "Color.h"
#include <iostream>

/*
 *
 */
DialogStyleEditor::DialogStyleEditor(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
:Gtk::Dialog(cobject)
{
	ref_document = NULL;

	//
	//
	entryName = NULL;
	buttonFont = NULL;
	buttonBold = NULL;
	buttonItalic = NULL;
	buttonUnderline = NULL;
	buttonStrikeout = NULL;

	buttonPrimaryColor = NULL;
	buttonSecondaryColor = NULL;
	buttonOutlineColor = NULL;
	buttonShadowColor = NULL;
	
	spinMarginL = NULL;
	spinMarginR = NULL;
	spinMarginV = NULL;

	spinAngle = NULL;
	spinScaleX = NULL;
	spinScaleY = NULL;
	spinSpacing = NULL;

	radioOutline = NULL;
	spinOutline = NULL;
	spinShadow = NULL;
	radioOpaqueBox = NULL;
	//
	//

	refGlade->get_widget("vboxEdit", vbox2);

	refGlade->get_widget("buttonNewStyle", buttonNewStyle);
	refGlade->get_widget("buttonDeleteStyle", buttonDeleteStyle);
	refGlade->get_widget("buttonCopyStyle", buttonCopyStyle);
	refGlade->get_widget("buttonManageStyles", buttonManageStyles);
	refGlade->get_widget("treeviewStyle", treeviewStyle);

	refGlade->get_widget("entryName", entryName);
	refGlade->get_widget("buttonFont", buttonFont);
	
	refGlade->get_widget("buttonBold", buttonBold);
	refGlade->get_widget("buttonItalic", buttonItalic);
	refGlade->get_widget("buttonUnderline", buttonUnderline);
	refGlade->get_widget("buttonStrikeout", buttonStrikeout);

	refGlade->get_widget("buttonPrimaryColor", buttonPrimaryColor);
	refGlade->get_widget("buttonSecondaryColor", buttonSecondaryColor);
	refGlade->get_widget("buttonOutlineColor", buttonOutlineColor);
	refGlade->get_widget("buttonShadowColor", buttonShadowColor);
	
	refGlade->get_widget("spinMarginL", spinMarginL);
	refGlade->get_widget("spinMarginR", spinMarginR);
	refGlade->get_widget("spinMarginV", spinMarginV);

	refGlade->get_widget("spinAngle", spinAngle);
	refGlade->get_widget("spinScaleX", spinScaleX);
	refGlade->get_widget("spinScaleY", spinScaleY);
	refGlade->get_widget("spinSpacing", spinSpacing);

	refGlade->get_widget("radioOutline", radioOutline);
	refGlade->get_widget("spinOutline", spinOutline);
	refGlade->get_widget("spinShadow", spinShadow);
	refGlade->get_widget("radioOpaqueBox", radioOpaqueBox);

	refGlade->get_widget("buttonAlignment1", buttonAlignment[0]);
	refGlade->get_widget("buttonAlignment2", buttonAlignment[1]);
	refGlade->get_widget("buttonAlignment3", buttonAlignment[2]);
	refGlade->get_widget("buttonAlignment4", buttonAlignment[3]);
	refGlade->get_widget("buttonAlignment5", buttonAlignment[4]);
	refGlade->get_widget("buttonAlignment6", buttonAlignment[5]);
	refGlade->get_widget("buttonAlignment7", buttonAlignment[6]);
	refGlade->get_widget("buttonAlignment8", buttonAlignment[7]);
	refGlade->get_widget("buttonAlignment9", buttonAlignment[8]);
	//


	//
	{
		//treeviewStyle->set_model(ref_styleModel);

		Gtk::TreeViewColumn* _column = NULL;
		Gtk::CellRendererText* _renderer = NULL;

		_column = manage(new Gtk::TreeViewColumn(_("Styles")));
		_renderer = manage(new Gtk::CellRendererText());

		_column->pack_start(*_renderer, false);
		_column->add_attribute(_renderer->property_text(), column.name);

		treeviewStyle->append_column(*_column);

		treeviewStyle->get_selection()->signal_changed().connect(
				sigc::mem_fun(*this, &DialogStyleEditor::on_select_style_changed));
	}
	
	for(unsigned int i=0; i<9; ++i)
	{
		buttonAlignment[i]->signal_toggled().connect(
				sigc::bind<unsigned int>(sigc::mem_fun(*this, &DialogStyleEditor::on_button_alignment_changed), i+1));
	}
	// signaux
#define CONNECT(widget,signal,callback) widget->signal().connect(sigc::mem_fun(*this, &DialogStyleEditor::callback));

	CONNECT(buttonNewStyle, signal_clicked, on_new_style);
	CONNECT(buttonDeleteStyle, signal_clicked, on_delete_style);
	CONNECT(buttonCopyStyle, signal_clicked, on_copy_style);
	CONNECT(buttonManageStyles, signal_clicked, on_manage_styles);

	CONNECT(entryName, signal_activate, on_entry_name_changed);

	CONNECT(buttonFont, signal_font_set, on_button_font_changed);

	CONNECT(buttonBold, signal_toggled, on_button_bold_toggled);
	CONNECT(buttonItalic, signal_toggled, on_button_italic_toggled);
	CONNECT(buttonUnderline, signal_toggled, on_button_underline_toggled);
	CONNECT(buttonStrikeout, signal_toggled, on_button_strikeout_toggled);

	CONNECT(buttonPrimaryColor, signal_color_set, on_color_primary_changed);
	CONNECT(buttonSecondaryColor, signal_color_set, on_color_secondary_changed);
	CONNECT(buttonOutlineColor, signal_color_set, on_color_outline_changed);
	CONNECT(buttonShadowColor, signal_color_set, on_color_shadow_changed);
	
	CONNECT(spinMarginL, signal_value_changed, on_spin_margin_l_changed);
	CONNECT(spinMarginR, signal_value_changed, on_spin_margin_r_changed);
	CONNECT(spinMarginV, signal_value_changed, on_spin_margin_v_changed);

	CONNECT(spinAngle, signal_value_changed, on_spin_angle_changed);
	CONNECT(spinScaleX, signal_value_changed, on_spin_scale_x_changed);
	CONNECT(spinScaleY, signal_value_changed, on_spin_scale_y_changed);
	CONNECT(spinSpacing, signal_value_changed, on_spin_spacing_changed);

	CONNECT(radioOutline, signal_toggled, on_radio_outline_changed);
	CONNECT(spinOutline, signal_value_changed, on_spin_outline_changed);
	CONNECT(spinShadow, signal_value_changed, on_spin_shadow_changed);
	CONNECT(radioOpaqueBox, signal_toggled, on_radio_opaque_box_changed);
	
#undef CONNECT

	buttonPrimaryColor->set_use_alpha(true);
	buttonSecondaryColor->set_use_alpha(true);
	buttonOutlineColor->set_use_alpha(true);
	buttonShadowColor->set_use_alpha(true);

	on_select_style_changed();

	//show_all();
	//run();
}

void DialogStyleEditor::execute()
{
	Document *doc = SE::getInstance()->getDocument();
	g_return_if_fail(doc);
	
	ref_document = doc;
	ref_styleModel = doc->get_style_model();
	
	treeviewStyle->set_model(ref_styleModel);

	run();
}

/*
 *	y a t'il un style select pour edition
 */
bool DialogStyleEditor::has_select()
{
	return iter;
}

void DialogStyleEditor::on_select_style_changed()
{
	iter = treeviewStyle->get_selection()->get_selected();
	
	if(iter)
	{
		vbox2->set_sensitive(true);
		on_init_style();
	}
	else
	{
		vbox2->set_sensitive(false);
	}
}

/*
 *	init l'interface avec le style select
 */
void DialogStyleEditor::on_init_style()
{
	g_return_if_fail(has_select());

	entryName->set_text( (*iter)[column.name] );

	//font
	std::ostringstream oss_font_size;

	oss_font_size << (*iter)[column.font_size];
	
	Glib::ustring font_name_size = (*iter)[column.font_name] + " " + oss_font_size.str();
	buttonFont->set_font_name( font_name_size);


	buttonBold->set_active( (*iter)[column.bold] );
	buttonItalic->set_active( (*iter)[column.italic] );
	buttonUnderline->set_active( (*iter)[column.underline] );
	buttonStrikeout->set_active( (*iter)[column.strikeout] );

	// color
	Color color;

	// primary
	color.set((*iter)[column.primary_colour]);
	color.initColorButton(*buttonPrimaryColor);

	// secondary
	color.set((*iter)[column.secondary_colour]);
	color.initColorButton(*buttonSecondaryColor);

	// outline
	color.set((*iter)[column.outline_colour]);
	color.initColorButton(*buttonOutlineColor);
	// shadow
	color.set((*iter)[column.shadow_colour]);
	color.initColorButton(*buttonShadowColor);


	// margin
	spinMarginL->set_value( (*iter)[column.margin_l] );
	spinMarginR->set_value( (*iter)[column.margin_r] );
	spinMarginV->set_value( (*iter)[column.margin_v] );

	// font angle,scale x, scale y, spacing
	spinAngle->set_value( (*iter)[column.angle] );
	spinScaleX->set_value( (*iter)[column.scale_x] );
	spinScaleY->set_value( (*iter)[column.scale_y] );
	spinSpacing->set_value( (*iter)[column.spacing] );

	if((*iter)[column.border_style] == 1)
		radioOutline->set_active(true);
	else
		radioOpaqueBox->set_active(true);

	spinOutline->set_value((*iter)[column.outline]);
	spinShadow->set_value((*iter)[column.shadow]);

	buttonAlignment[(*iter)[column.alignment] -1 ]->set_active(true);
}

void DialogStyleEditor::on_entry_name_changed()
{
	g_return_if_fail(has_select());
	
	Glib::ustring text = entryName->get_text();

	(*iter)[column.name] = text;
}

void DialogStyleEditor::on_button_font_changed()
{
	g_return_if_fail(has_select());

	Pango::FontDescription description(buttonFont->get_font_name());

	Glib::ustring name = description.get_family();
	unsigned int size = description.get_size() / 1000;

	(*iter)[column.font_name] = name;
	(*iter)[column.font_size] = size;
}
	
void DialogStyleEditor::on_button_bold_toggled()
{
	g_return_if_fail(has_select());

	bool state = buttonBold->get_active();

	(*iter)[column.bold] = state;
}

void DialogStyleEditor::on_button_italic_toggled()
{
	g_return_if_fail(has_select());

	bool state = buttonItalic->get_active();

	(*iter)[column.italic] = state;
}

void DialogStyleEditor::on_button_underline_toggled()
{
	g_return_if_fail(has_select());

	bool state = buttonUnderline->get_active();

	(*iter)[column.underline] = state;
}

void DialogStyleEditor::on_button_strikeout_toggled()
{
	g_return_if_fail(has_select());

	bool state = buttonStrikeout->get_active();

	(*iter)[column.strikeout] = state;
}

void DialogStyleEditor::on_color_primary_changed()
{
	g_return_if_fail(has_select());

	Color color;
	color.getFromColorButton(*buttonPrimaryColor);

	(*iter)[column.primary_colour] = color.getRGBA();
}

void DialogStyleEditor::on_color_secondary_changed()
{
	g_return_if_fail(has_select());

	Color color;
	color.getFromColorButton(*buttonSecondaryColor);
	
	(*iter)[column.secondary_colour] = color.getRGBA();
}

void DialogStyleEditor::on_color_outline_changed()
{
	g_return_if_fail(has_select());

	Color color;
	color.getFromColorButton(*buttonOutlineColor);
	
	(*iter)[column.outline_colour] = color.getRGBA();
}

void DialogStyleEditor::on_color_shadow_changed()
{
	g_return_if_fail(has_select());

	Color color;
	color.getFromColorButton(*buttonShadowColor);
	
	(*iter)[column.shadow_colour] = color.getRGBA();
}

void DialogStyleEditor::on_spin_margin_l_changed()
{
	g_return_if_fail(has_select());

	double value = spinMarginL->get_value();

	(*iter)[column.margin_l] = (unsigned int) value;
}

void DialogStyleEditor::on_spin_margin_r_changed()
{
	g_return_if_fail(has_select());

	double value = spinMarginR->get_value();

	(*iter)[column.margin_r] = (unsigned int) value;
}

void DialogStyleEditor::on_spin_margin_v_changed()
{
	g_return_if_fail(has_select());

	double value = spinMarginV->get_value();

	(*iter)[column.margin_v] = (unsigned int) value;
}

void DialogStyleEditor::on_spin_angle_changed()
{
	g_return_if_fail(has_select());

	double value = spinAngle->get_value();

	(*iter)[column.angle] = (unsigned int) value;
}

void DialogStyleEditor::on_spin_scale_x_changed()
{
	g_return_if_fail(has_select());

	double value = spinScaleX->get_value();

	(*iter)[column.scale_x] = (unsigned int) value;
}

void DialogStyleEditor::on_spin_scale_y_changed()
{
	g_return_if_fail(has_select());

	double value = spinScaleY->get_value();

	(*iter)[column.scale_y] = (unsigned int) value;
}

void DialogStyleEditor::on_spin_spacing_changed()
{
	g_return_if_fail(has_select());

	double value = spinSpacing->get_value();

	(*iter)[column.spacing] = (unsigned int) value;
}



void DialogStyleEditor::on_radio_outline_changed()
{
	g_return_if_fail(has_select());

	if(radioOutline->get_active())
		(*iter)[column.border_style] = 1;
}

void DialogStyleEditor::on_spin_outline_changed()
{
	g_return_if_fail(has_select());

	double value = spinOutline->get_value();

	(*iter)[column.outline] = (unsigned int) value;
}

void DialogStyleEditor::on_spin_shadow_changed()
{
	g_return_if_fail(has_select());

	double value = spinShadow->get_value();

	(*iter)[column.shadow] = (unsigned int) value;
}

void DialogStyleEditor::on_radio_opaque_box_changed()
{
	g_return_if_fail(has_select());

	if(radioOpaqueBox->get_active())
		(*iter)[column.border_style] = 3;
}

	
void DialogStyleEditor::on_button_alignment_changed(unsigned int num)
{
	g_return_if_fail(has_select());

	if(buttonAlignment[num-1]->get_active())
		(*iter)[column.alignment] = num;
}

void DialogStyleEditor::on_new_style()
{
	Gtk::TreeIter it = ref_styleModel->append();
	(*it)[column.name] = "New Style";

	treeviewStyle->get_selection()->select(it);
}

void DialogStyleEditor::on_delete_style()
{
	if(has_select() == false)
		return;
	
	iter = ref_styleModel->erase(iter);
		
	if(iter)
		treeviewStyle->get_selection()->select(iter);

#warning "check SubtitleModel for remove style erase"

}

void DialogStyleEditor::on_copy_style()
{
	if(has_select() == false)
		return;

	Gtk::TreeIter src = iter;

	Gtk::TreeIter dst = ref_styleModel->copy(src);

	(*dst)[column.name] = (*dst)[column.name] + "-copy";

	treeviewStyle->get_selection()->select(dst);
}

void DialogStyleEditor::on_manage_styles()
{
	std::cerr << "DialogStyleEditor::on_manage_styles()" << std::endl;
}


