#ifndef _DialogScriptProperties_h
#define _DialogScriptProperties_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <libglademm/xml.h>
#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/comboboxentry.h>
#include "ISubtitleEditor.h"


class DialogScriptProperties : public Gtk::Dialog
{
public:
	DialogScriptProperties(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

	void execute();
protected:
	void init(ScriptInfo *info);

	void on_entry_script_type_changed();
	void on_entry_point_time_changed();
	
	void on_entry_title_changed();
	void on_entry_original_script_changed();
	void on_entry_original_translation_changed();
	void on_entry_original_editing_changed();
	void on_entry_original_timing_changed();
	void on_entry_sync_point_changed();
	void on_entry_script_updated_by_changed();
	void on_entry_update_details_changed();

	void on_entry_play_res_x_changed();
	void on_entry_play_res_y_changed();
	void on_entry_play_depth_changed();
	
	void on_combo_collisions_changed();
	void on_entry_warp_style_changed();

	void on_spin_timer_changed();
protected:
	ScriptInfo *scriptInfo;

	Gtk::Entry*	entryScriptType;
	Gtk::Entry*	entryPointTime;
	
	Gtk::Entry*	entryTitle;
	Gtk::Entry*	entryOriginalScript;
	Gtk::Entry*	entryOriginalTranslation;
	Gtk::Entry*	entryOriginalEditing;
	Gtk::Entry*	entryOriginalTiming;
	Gtk::Entry*	entrySyncPoint;
	Gtk::Entry*	entryScriptUpdatedBy;
	Gtk::Entry*	entryUpdateDetails;
	
	Gtk::Entry*	entryPlayResX;
	Gtk::Entry*	entryPlayResY;
	Gtk::Entry*	entryPlayDepth;
	
	Gtk::ComboBoxEntry*	comboCollisions;
	Gtk::Entry*	entryWarpStyle;

	Gtk::SpinButton*	spinTimer;
};

#endif//_DialogScriptProperties_h

