/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */


#include "DialogScale.h"
#include "utility.h"

/*
 *
 */
DialogScale::DialogScale(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
:Gtk::Dialog(cobject)
{
	refGlade->get_widget("spinSource1", m_spinSource1);
	refGlade->get_widget("spinSource2", m_spinSource2);
	refGlade->get_widget("entryDest1", m_entryDest1);
	refGlade->get_widget("entryDest2", m_entryDest2);

	// default values
	m_entryDest1->set_text(SubtitleTime::null());
	m_entryDest2->set_text(SubtitleTime::null());
	
	m_spinSource1->signal_value_changed().connect(
			sigc::mem_fun(*this, &DialogScale::on_spin1_changed));
	
	m_spinSource2->signal_value_changed().connect(
			sigc::mem_fun(*this, &DialogScale::on_spin2_changed));

	m_entryDest1->signal_activate().connect(
			sigc::mem_fun(*this, &DialogScale::on_entry1_changed));
	
	m_entryDest2->signal_activate().connect(
			sigc::mem_fun(*this, &DialogScale::on_entry2_changed));
}

/*
 *
 */
void DialogScale::execute()
{
	Document *doc = SE::getInstance()->getDocument();
	g_return_if_fail(doc);

	
	m_model = doc->get_subtitle_model();
	
	int min = 1;
	
	int max = m_model->getSize();
	
	m_spinSource1->set_range(min, max);
	m_spinSource2->set_range(min, max);
	
	m_spinSource1->set_value(min);
	m_spinSource2->set_value(max);

	show();
	
	if( run() == Gtk::RESPONSE_OK)
	{
		SubtitleColumnRecorder column;
		// on recupere l'emplacement du debut et de la fin
		unsigned int num1 = (unsigned int)m_spinSource1->get_value();
		unsigned int num2 = (unsigned int)m_spinSource2->get_value();

		// on recupere le temps pour le debut et la fin
		Gtk::TreeIter it1 = (m_model->find(num1));
		Gtk::TreeIter it2 = (m_model->find(num2));

		SubtitleTime src1((*it1)[column.start]);
		SubtitleTime src2((*it2)[column.start]);
		// on recupere la nouvelle position voulu pour le debut et la fin
		SubtitleTime dest1(m_entryDest1->get_text());
		SubtitleTime dest2(m_entryDest2->get_text());
		// on deplace src1 a dest1 et src2 a dest2
		m_model->scale(src1,dest1, src2,dest2);
	}

	hide();
}

/*
 *
 */
void DialogScale::on_spin1_changed()
{
	unsigned int i = (unsigned int)m_spinSource1->get_value();

	Gtk::TreeIter iter = m_model->find(i);
	if(iter)
	{
		SubtitleColumnRecorder column;
		m_entryDest1->set_text((*iter)[column.start]);
	}
}

/*
 *
 */
void DialogScale::on_spin2_changed()
{
	unsigned int i = (unsigned int)m_spinSource2->get_value();

	Gtk::TreeIter iter = m_model->find(i);
	if(iter)
	{
		SubtitleColumnRecorder column;
		m_entryDest2->set_text((*iter)[column.start]);
	}
}

/*
 *
 */
void DialogScale::on_entry1_changed()
{
	Glib::ustring text = m_entryDest1->get_text();
	if(SubtitleTime::validate(text) == false)
		m_entryDest1->set_text(SubtitleTime::null());
}

/*
 *
 */
void DialogScale::on_entry2_changed()
{
	Glib::ustring text = m_entryDest2->get_text();
	if(SubtitleTime::validate(text) == false)
		m_entryDest2->set_text(SubtitleTime::null());
}

