#ifndef _Dialog_h
#define _Dialog_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <gtkmm/dialog.h>
#include <gtkmm/label.h>
#include <gtkmm/entry.h>
#include <gtkmm/table.h>
#include <gtkmm/filechooserdialog.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/aboutdialog.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/fontbutton.h>
#include <gtkmm/colorbutton.h>
#include <gtkmm/treeview.h>
#include <gtkmm/comboboxentrytext.h>
#include <gtkmm/comboboxtext.h>

#include <libglademm/xml.h>

#include "SubtitleTime.h"
#include "SubtitleModel.h"
#include "StyleModel.h"
#include "Document.h"
#include "SubtitleView.h"
#include <iostream>
#include "DialogFileChooser.h"

/*
 *
 */
class GtkSubtitleTime : public Gtk::Table
{
public:
	GtkSubtitleTime();

	void set_value(int h, int m, int s, int ms);
	void set_value(const SubtitleTime &time);

	SubtitleTime get_value();

protected:
	Gtk::Label			m_labelHours;
	Gtk::SpinButton m_spinHours;
	Gtk::Label			m_labelMins;
	Gtk::SpinButton m_spinMins;
	Gtk::Label			m_labelSecs;
	Gtk::SpinButton m_spinSecs;
	Gtk::Label			m_labelMSecs;
	Gtk::SpinButton m_spinMSecs;
};


/*
 *
 */
class DialogOpenSubtitle : public DialogFileChooser
{
public:
	DialogOpenSubtitle();
	~DialogOpenSubtitle();
};



/*
 *
 */
class DialogSaveSubtitle : public DialogFileChooser
{
public:
	DialogSaveSubtitle();
	~DialogSaveSubtitle();
};



/*
 *
 */
class DialogOpenMovie : public Gtk::FileChooserDialog
{
public:
	DialogOpenMovie();
	~DialogOpenMovie();
};


/*
 *
 */
class DialogOpenMedia : public Gtk::FileChooserDialog
{
public:
	DialogOpenMedia();
	~DialogOpenMedia();
};

/*
 *
 */
class DialogSaveWaveform : public Gtk::FileChooserDialog
{
public:
	DialogSaveWaveform();
	~DialogSaveWaveform();
};



/*
 *
 */
class DialogImportText : public DialogFileChooser
{
public:
	DialogImportText();
};



/*
 *
 */
class DialogExportText : public DialogFileChooser
{
public:
	DialogExportText();
};





/*
 *
 */
class DialogMoveSubtitle : public Gtk::Dialog
{
public:
	DialogMoveSubtitle();
	DialogMoveSubtitle(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

	void set_value(const SubtitleTime &start);
	SubtitleTime get_value();

protected:
	Gtk::Table		m_table;
	Gtk::Label		m_labelDest;
	GtkSubtitleTime m_timer;
	Gtk::Label		m_labelOption;
	Gtk::RadioButton	m_radioAll;
	Gtk::RadioButton	m_radioCurrent;
};


/*
 *
 */
class DialogSetAllEndTime : public Gtk::Dialog
{
public:
	DialogSetAllEndTime();

	enum Type
	{
		ADD,
		SET,
	};

	Type		get_type();
	SubtitleTime	get_time();
	
protected:
	Gtk::Table		m_table;

	Gtk::Label		m_labelRadio;
	Gtk::RadioButton	m_radioAdd;
	Gtk::RadioButton	m_radioSet;

	Gtk::Label		m_label;
	GtkSubtitleTime m_time;
};


#include "GstLaunch.h"

/*
 *
 */
class DialogVideoProperties : public Gtk::Dialog, public GstLaunch
{
public:
	DialogVideoProperties(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);

	void execute();

protected:
	void info_update();
protected:
	Gtk::Label*	m_label_title;
	Gtk::Label*	m_label_duration;
	Gtk::Label*	m_label_dimensions;
	Gtk::Label*	m_label_video_codec;
	Gtk::Label*	m_label_framerate;
	Gtk::Label*	m_label_audio_codec;
};

#endif//_Dialog_h
