/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXTGLUEWIDGET_H
#define _TEXTGLUEWIDGET_H

// sc
#include "util/types.h"
class DiffInfoModel;
class TextModel;
class DiffInfo;

// qt
#include <qwidget.h>


class TextGlueWidget : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  TextGlueWidget( QWidget *parent=0, const char *name=0 );
  virtual ~TextGlueWidget();

  void setModel( DiffInfoModel *model );
  void setModel( TextModel* left, TextModel* right );
  void setLineCnt( sc::Size l );

  void setActiveDiff( int num );

  //void setFlags( unsigned long flags );
  QSize sizeHint() const;

public slots:
  void setScrollPosY( int y );

protected:
  void paintEvent( QPaintEvent * );
  //int width() const;
  //int height() const;

private:
  QColor getColor( DiffInfo&, bool left );

  DiffInfoModel* _model;       // data source
  TextModel*     _left;
  TextModel*     _right;

  int            _lnColumns;   // char columns
  int            _lnLeftPad;   // pixel
  int            _lnRightPad;  // pixel
  sc::Size       _lines;       // pretend to have this number of lines

  int            _currDiff;    // highlighted diff number
  
  unsigned long  _flags;

  int            _ypos;        // scroll position

  static QColor  _bg;
  static QColor  _fg;
  static QColor  _fgMerge;

  static QColor  _bgDash;
  static QColor  _fgDash;
};


#endif // _TEXTGLUEWIDGET_H
