/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UNLOCKPARAM_H
#define _SC_UNLOCKPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "util/String.h"

/**
 * Parameter class for UnockCmd.
 */
class UnlockParam : public ScParam
{
public:
  UnlockParam( const svn::Paths& pathsOrUrls, bool breakLocks )
    : _pathsOrUrls(pathsOrUrls), _breakLocks(breakLocks)
  {
  }

  ~UnlockParam()
  {
  }

  const svn::Paths& getPathsOrUrls() const
  {
    return _pathsOrUrls;
  }

  bool getBreakLocks() const
  {
    return _breakLocks;
  }

  ScParamAccept(UnlockParam);

private:
  // in
  svn::Paths  _pathsOrUrls;
  bool        _breakLocks;
};

#endif // _SC_UNLOCKPARAM_H
