/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCSTATUSLVI_H
#define _SC_WCSTATUSLVI_H

// sc
#include "svn/WcStatus.h"

// qt
#include <qlistview.h>


class WcStatusLvi : public QListViewItem
{
  typedef QListViewItem super;

public:
  WcStatusLvi( QListView* parent, const svn::WcStatusPtr status );
  WcStatusLvi( QListViewItem* parent, const svn::WcStatusPtr status );
  virtual ~WcStatusLvi();

  void startRename( int col );
  void okRename( int col );
  void cancelRename( int col );
  //void paintFocus( QPainter* p, const QColorGroup& cg, const QRect& r );
  void paintCell( QPainter* p, const QColorGroup& cg, int column, int width, int alignment );
  //void paintBranches( QPainter* p, const QColorGroup& cg, int w, int y, int h, GUIStyle s );

  bool acceptDrop( const QMimeSource* mime ) const;

  QString text( int column ) const;
  QString key( int column, bool ascending ) const;

  int compare( QListViewItem * i, int col, bool ascending ) const;

  void setParentPath( const QString& parentPath );
  const QString& getParentPath() const;
  svn::WcStatusPtr getStatus() const;

private:
  void init();

  QString          _parentPath;
  svn::WcStatusPtr _status;
  
  bool             _rename;      ///< we are in a rename?
};

#endif // _SC_WCSTATUSLVI_H

