/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DRAGINFO_H
#define _SC_DRAGINFO_H

// qt
#include <qdatetime.h>
#include <qpoint.h>
class QTimer;
class QListViewItem;


/**
 * helper class to hold drag & drop information
 */
class DragInfo
{
public:
  DragInfo( QTimer* timer );
  
  int getScrollDelta( int height, int visible ) const;

  void startTimer();
  void stopTimer();

  void setDragPos( const QPoint& pos );
  void setCurrLvi( QListViewItem* lvi );
    
  void handleIdleItem();
    
private:
  QTimer*        _timer;     // timer for drag&drop timing
  QPoint         _pos;       // current mouse position
  QListViewItem* _currLvi;   // current item at mouse postion

  QTime          _lastHit;   // time when idle on last item started
  QListViewItem* _lastLvi;   // last idle item
};

#endif /*DRAGINFO_H_*/
