/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "DragInfo.h"

// qt
#include <qtimer.h>
#include <qlistview.h>


DragInfo::DragInfo( QTimer* timer ) : _timer(timer), _currLvi(0), _lastLvi(0)
{
}

int DragInfo::getScrollDelta( int height, int visible ) const
{
  // down fast
  if( _pos.y() > visible - 10 )
  {
    return 10;
  }
  // down slow
  else if( _pos.y() > visible - 20 )
  {
    return 5;
  }
  // up fast
  else if( height > 0 && _pos.y() < 10 )
  {
    return -10;
  }
  // up slow
  else if( height > 0 && _pos.y() < 20 )
  {
    return -5;
  }
  
  return 0;    
}

void DragInfo::startTimer()
{
  // TODO:
  // this method is called from RepositoryFilesWidget/WorkingCopyFilesWidget
  // dragMoveEvent slot.
  // problem:
  // on MacOSX  dragMoveEvent is NOT called if the mouse doesn't move.
  // on Windows dragMoveEvent is called even if the mouse doesn't move.
  // because of this the timer event is never fired on Windows since we
  // we restart the timer before it can do so.
#if 0
  if( _timer->isActive() )
  {
    return;
  }
#endif

  // reducing the time helps too...
  _timer->start( 10 /*100*/, false );
}

void DragInfo::stopTimer()
{
  _timer->stop();
}

void DragInfo::setDragPos( const QPoint& pos )
{
  _pos = pos;
}

void DragInfo::setCurrLvi( QListViewItem* lvi )
{
  _currLvi = lvi;
}
  
void DragInfo::handleIdleItem()
{
  if( ! _currLvi )
  {
    _lastLvi = NULL;
    return;
  }
  
  if( _currLvi != _lastLvi )
  {
    _lastLvi = _currLvi;
    _lastHit = QTime::currentTime();
  }
  else if( _currLvi->isExpandable() && _lastHit.elapsed() > 1000 )
  {
    _currLvi->setOpen( !_currLvi->isOpen() );
    _lastHit = QTime::currentTime();
  }
}
