/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [scn_io.h]             Scanner Definition Primimitives                   */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef scn_io_INCL
#define scn_io_INCL


#include "standard.h"
#include "binimg.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   Beside copying and disposing of scanner definitions
   this module provides functions that
   1) generate a C module for a given scanner definition
   2) unload a scanner definition to a binary image file
   3) load a scanner definition from a binary image file.
*/

/* ------------------------------ Types & Macros ---------------------------- */

/* 
  <p><b>Identifier of other other</b>
  <p><br>Separator between token ID and pattern<b>
*/

#define SCN_TOK_Other            "[other]"
#define SCN_SEP_TOK_ID_PATTERN   '@'

AbstractType( Scn_T ); /* Abstract scanner type */

/* ------------------------------ Basics ------------------------------------ */

c_string Scn_LanguageId(Scn_T x)
/* language or group name of scanner definition 'x' */
;

Scn_T Scn_copy(Scn_T x);               /* copies scanner definition 'x'     */
void  Scn_free(Scn_T x);               /* frees scanner definition 'x'      */

/* ----------------------------- Binary Image ------------------------------- */

Scn_T Scn_fget_bin(BinImg_T img)
/* loads a scanner definition
   from binary image 'img' (reentrant)
*/
;

Scn_T Scn_get_bin(void)
/* loads a scanner definition
   from the current ( previously opened ) image
*/
;

void Scn_get(c_string Language, Scn_T *x)
/* loads a scanner definition named 'Language' into 'x'
   from image [$PATH/]<Language>.lim
*/
;

void Scn_get_env(c_string Environ, c_string Language, Scn_T *x)
/* loads a scanner definition named 'Language' into 'x'
   from image [$'Environ'/]<Language>.lim
*/
;

void Scn_get_file(c_string file, Scn_T *x)
/* loads a scanner definition from 'file' into 'x'
*/
;

void Scn_fput_bin(BinImg_T img, Scn_T x)
/* unloads scanner definition 'x'
   to binary image 'img' (reentrant)
*/
;

void Scn_put_bin(Scn_T x)
/* unloads scanner definition 'x'
   to the current ( previously opened ) image
*/
;

void Scn_put(c_string Environ, Scn_T x)
/* unloads scanner definition 'x'
   to image [$'Environ'/]<Language>.lim
*/
;


/* ----------------------------- C-Module ----------------------------------- */

void Scn_C_Source(FILE* fp, c_string fid, Scn_T x)
/* writes source for scanner ( group ) definition 'x' to file 'fp';
   produces a source header if filename 'fid' is not empty
*/
;

void Scn_C_Modul(c_string Environ, Scn_T x, c_bool shortform)
/* creates source [$'Environ'/]<Language>_lim.c
   for scanner ( group ) definition 'x'
*/
;

void Scn_Src_Source(FILE* fp, c_string fid, Scn_T x)
/* writes source for scanner ( group ) definition 'x' to file 'fp';
   produces a source header if filename 'fid' is not empty
*/
;

void Scn_Src_Modul(c_string Environ, Scn_T x)
/* creates source [$'Environ'/]<Language>.ltbl
   for scanner ( group ) definition 'x'
*/
;



#ifdef __cplusplus
}
#endif

#endif
