/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* carol@strongswan.org */
  3, X'6361726f6c407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=carol@strongswan.org' */
  11, X'1fa1a988d9648cb5a0a2546439b4f23d745d6e7c'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b53082029da003020102020100300d06092a864886f70d01010405003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303131303134355a170d3134303930383131303134355a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d010104050003820101009ad74e3e60592dfb9b21c78628bd76b63090c1720c74bf94753cad6fddadc9c776eb39d3bfaa52136bf528840078386308fcf79503bd3d1ad6c15ac38e10c846bff7888a03cfe7fa0e644b522b2af5aedf0bbc508dc48330a180757772771095059b2be148f58dc0c753b59e9d6bfb02e9b685a928a284531b187313fd2b835bc9ea27d0020739a8d485e88bdede9a45cde6d28ed553b0e8e92dabf877bed59abf9d151f15e4f2d00b5e6e49fcb665293d2296697926c2954dae367542ef6e98053e76d2728732f6ce69f284f0b856aa6c2823a9ee29b280a66f50828f9b5cf27f84feca3c31c24897db156c7a833768ab306f51286457a51f09dd53bbb4190f'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=carol@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=carol@strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 3
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_CAROL', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id
) VALUES (
  'home', 1, 3, 5
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'home', 'ipsec _updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 2
);

