/*
 * Copyright (C) 2008 Tobias Brunner
 * Hochschule fuer Technik Rapperswil
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * $Id: kernel_pfkey_plugin.h 4361 2008-10-01 16:47:51Z tobias $
 */

/**
 * @defgroup kernel_pfkey kernel_pfkey
 * @ingroup cplugins
 *
 * @defgroup kernel_pfkey_plugin kernel_pfkey_plugin
 * @{ @ingroup kernel_pfkey
 */

#ifndef KERNEL_PFKEY_PLUGIN_H_
#define KERNEL_PFKEY_PLUGIN_H_

#include <plugins/plugin.h>

typedef struct kernel_pfkey_plugin_t kernel_pfkey_plugin_t;

/**
 * PF_KEY kernel interface plugin
 */
struct kernel_pfkey_plugin_t {

	/**
	 * implements plugin interface
	 */
	plugin_t plugin;
};

/**
 * Create a kernel_pfkey_plugin instance.
 */
plugin_t *plugin_create();

#endif /* KERNEL_PFKEY_PLUGIN_H_ @} */
