/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  202, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* carol@strongswan.org */
  3, X'6361726f6c407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=carol@strongswan.org' */
  202, X'985c23660cd9b9a7554da6a4aa31ea02230fd482'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b53082029da003020102020100300d06092a864886f70d01010405003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303131303134355a170d3134303930383131303134355a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d010104050003820101009ad74e3e60592dfb9b21c78628bd76b63090c1720c74bf94753cad6fddadc9c776eb39d3bfaa52136bf528840078386308fcf79503bd3d1ad6c15ac38e10c846bff7888a03cfe7fa0e644b522b2af5aedf0bbc508dc48330a180757772771095059b2be148f58dc0c753b59e9d6bfb02e9b685a928a284531b187313fd2b835bc9ea27d0020739a8d485e88bdede9a45cde6d28ed553b0e8e92dabf877bed59abf9d151f15e4f2d00b5e6e49fcb665293d2296697926c2954dae367542ef6e98053e76d2728732f6ce69f284f0b856aa6c2823a9ee29b280a66f50828f9b5cf27f84feca3c31c24897db156c7a833768ab306f51286457a51f09dd53bbb4190f'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=carol@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, CN=carol@strongswan.org' */
  1, X'308204a30201000282010100b81b84920408e086c8d278d3ad2e9ffc01b89e8c423b612b908010f8174ff96f6729e84b185fb96e60783082c507ace9d64f79beb0252e05e5f1f7a89a0b33e6789f5deb665084cb230191c165bcad1a34563e011b349bb6ab517f01ecf7e2f4de961d36203b85e97811cb26b650cfd014d15dd2d2b71efd656e5638a24bf70986b8128bbae5f3b428d6360e03d3f4e816502e3d1d14d7165ab1a92a9fe15ef045d4e48ff5bd798ec80c9420962c9a9798b54a0ed2a00cf2c9651d7d9882e181c1ef6b1c43edcada2fd191e109962dbd26f38a00208c1ac3ed27a5924c60330c79878eb5c7a90960a6472f979aca9c5aee2bb4d0aed395b546c5e361910a063702030100010282010100a7870abc1f85c061858dd7baae24f61947abaa41f0e6bd85f9c83f28b175e980d0bc168f76cf6c199f18def3afbc4b40c0edb2d7accb3834cfc7bd57234d3c5de4b707ac737ea3478144255079761581f9cbdc41ff72809ad90ba069ad2ae7cf7057e29ee4f7a4e40c890c75de826c8768da16e9072af0bd1db6282902ade34cb1b9c3fdd00a8f0330328e18d477009ac5a43952fe05b7257b8b4e7f8f5288e858ef56ea3a031980d38b879e6327d949a8f3c19bf379c1297b3defc0a374a6ea6f1c0e8124247c33392ae446081f486f58bb41cbcba25915d37eefe0828408f7f679841588424ef59b6dee30805b926fa80e7ff57cb4817167ca72bf51c8cf9102818100da567b0cbbc426e4455ffdd1b8013644d9f47785b05b163a0155c81d57c0cd84fe73aa75125caf116de50b7adc369707ed91127db7d4422bb08cff5ddf91f4a0e5fb264e098fe6fe62f8a2ab933eeac41893f365d8165f79143855b5a5b7dc31c9b34a9d453ee7c8d7b24f89e3ed51bfeadc2e1102308a967b241dfb44c8ad6902818100d7dd78437c533a15fd1dd6b0634334e79c31d215017f5a8869e42cbada3fb09167585e087e72f91575441f7cca9a64246df57f0e45f1ae86a289a4307586aa1cc3cd069c65057cc3b0baac3634064e53179bde9af2531a5af2770a1d7ccbdc263f18299ad2ec0d224b718002633a546af74c7cac72ccdf253ab4370137bf829f02818063b2f5c15cc43716296fa9d167fa75b37eeb18e0dd24dac365f4abca6a55ca031ec5e6624b1e337afbf9890273282253267206458df9c8b5768b0bd8ebcc142e9c95d069f607d5ecf7789d9f473f85a841a8dd8df5dc518052715f01f14841ae22725271fa3abd5082de135fddca7277f660d05047f5ae73048bfb7ccf6deb7102818028b2b4ade48ebc70d0dc03521624e1a0992e3b71826ac462dbb40d4add430cc31d3ce7ddaa197b24b48b37748bae381b363006d8660f7edc1b60dff7d2f0a4b9efa0841290694c7088ad69327ef48167e1179e0c908b6278ab260e5e28dd36906f6cdacb39e10f48dbf8762dfd0f4e432c84db2c98285019f0cb7163656351f902818042a7d7d7f9416b3f3b50cf5815dfbc249cd3572e494c76d1ae99dc1e8bc63fbb32e5c18d5c4f90681e9046999cdcf0826f904350b9d67227f606382d9c7b3b1332d22744b2cefa691ab82dbec8e976a406b0902d0f4889392f80d39e2581ac42feed9085964650485e34811b04fa1f34c47cde5cbdd1d20f30111851a3c187ca'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 3
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 4
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_CAROL', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id, virtual
) VALUES (
  'home', 1, 3, 5, '0.0.0.0'
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'home', 'ipsec _updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 2
);

