#ifndef QUERYBITSET_H
#define QUERYBITSET_H

#include <map>
#include <string>

namespace jstreams {

class QueryBitset {
private:
    class Private;
    Private* p;
    int count;
public:
    QueryBitset();
    QueryBitset(const QueryBitset&);
    ~QueryBitset();
    const QueryBitset&operator=(const QueryBitset&);
};

class IndexManager;
class QueryBitsetCache {
private:
    std::map<std::string, const QueryBitset> cache;
    IndexManager* manager;
public:
    QueryBitsetCache(IndexManager*);
    bool hasQueryBitSet(const std::string& query) const;
    const QueryBitset getBitset(const std::string& query);
    void clear();
};

}

#endif
