#include "querybitset.h"
#include <boost/dynamic_bitset.hpp>
using namespace jstreams;
using namespace boost;

class QueryBitset::Private {
public:
    int count;
    dynamic_bitset<> bitset;
    
    Private() {
        count = 0;
    }
};

QueryBitset::QueryBitset() {
    p = 0;
}
QueryBitset::QueryBitset(const QueryBitset& q) {
    p = 0;
    *this = q;
}
const QueryBitset&
QueryBitset::operator=(const QueryBitset&q) {
    if (p && --p->count == 0) delete p;
    if (q.p) {
        p = q.p;
        p->count++;
    } else {
        p = 0;
    }
}
QueryBitset::~QueryBitset() {
    if (p && --p->count == 0) delete p;
}

QueryBitsetCache::QueryBitsetCache(IndexManager* im) {
    manager = im;
}
bool
QueryBitsetCache::hasQueryBitSet(const std::string& query) const {
    std::map<std::string, const QueryBitset>::const_iterator i;
    i = cache.find(query);
    return i == cache.end();
}
const QueryBitset
QueryBitsetCache::getBitset(const std::string& query) {
    QueryBitset set;
    return  set;
}
void
QueryBitsetCache::clear() {
    cache.clear();
}
