import straw
import SubscribeDialog
import straw.pytrayicon
import pygtk
pygtk.require('2.0')
import gtk

class Tray:
    _instance = None
    
    def __init__(self, ):
        self.tray = straw.pytrayicon.TrayIcon(straw.APPNAME);
        eventbox = gtk.EventBox()
        self.tray.add(eventbox)
        eventbox.connect("button_press_event", self.clicked)
        eventbox.connect("drag-data-received", self.on_drag_data_received)

        eventbox.drag_dest_set(
            gtk.DEST_DEFAULT_ALL,
            [('_NETSCAPE_URL', 0, 0),('text/uri-list ', 0, 1),('x-url/http', 0, 2)],
            gtk.gdk.ACTION_COPY | gtk.gdk.ACTION_MOVE)


        image = gtk.Image()
        pixbuf = gtk.gdk.pixbuf_new_from_file(straw.main.get_icon())
        scaled_buf = pixbuf.scale_simple(16,16,gtk.gdk.INTERP_BILINEAR)
        image.set_from_pixbuf(scaled_buf)
        eventbox.add(image)

        self._tooltip = gtk.Tooltips()
        self.unread_count = 0
        self._feedlist = straw.FeedList.get_instance()
        for feed in self._feedlist.flatten_list():
            self.__add_feed(feed)


    def feed_added(self, signal):
        self.__add_feed(signal.feed)

    def __add_feed(self, feed):
        feed.signal_connect(straw.NewItemsSignal, self.update)
        feed.signal_connect(straw.ItemsAddedSignal, self.update)
        feed.signal_connect(straw.ItemReadSignal, self.update)
        feed.signal_connect(straw.ItemDeletedSignal, self.update)
        feed.signal_connect(straw.AllItemsReadSignal, self.update)

    def update(self,signal):
        uritems = urfeeds = 0
        for ur in [f.number_of_unread for f in self._feedlist.flatten_list()]:
            if ur:
                uritems += ur
                urfeeds += 1
        if uritems == self.unread_count:
            return
        self.unread_count = uritems
        if uritems > 0:
            self._tooltip.set_tip(self.tray, _("%d new items")%uritems)
            self.tray.show_all()
        else:
            self.tray.hide()

    def clicked(self, signal, event):
        straw.main_window.present()
        straw.main_window.on_menu_scroll_next_activate()

    def on_drag_data_received(self, widget, context, x, y, data, info, timestamp):
        if data and data.format == 8:
            SubscribeDialog.show(data.data.split("\n")[0])
            context.finish(gtk.TRUE, gtk.FALSE, timestamp)
        else:
            context.finish(gtk.FALSE, gtk.FALSE, timestamp)

    def get_instance(klass):
        if klass._instance is None:
            klass._instance = klass()
        return klass._instance
    get_instance = classmethod(get_instance)
    
