import gtk
import gnome
import straw

class FileSelectionDialog(gtk.FileSelection):
    def __init__(self, title, file_ops=False):
        gtk.FileSelection.__init__(self, title)

        filename = 'mySubscriptions.opml'
        self._category = None

        self.set_transient_for(straw.main_window.get_window())
        self.set_property('show-fileops', file_ops)
        self.set_property('filename', filename)

        self._label = gtk.Label()
        option_menu = gtk.OptionMenu()

        selector = straw.CategorySelector(option_menu, self.select_category)
        selector.display_categories()

        fc = straw.FeedCategoryList.get_instance()
        if (len(fc.user_categories) > 0):
            hbox = self.action_area
            hbox.set_spacing(6)
            hbox.set_homogeneous(False)
            hbox.pack_start(self._label, expand=False, fill=False, padding=2)
            hbox.pack_start(option_menu, expand=True, fill=True, padding=2)
            hbox.show_all()

    def export_subscriptions(self):
        filename = self.get_filename()

        try:
            straw.OPMLExport.export(self._category, filename)
        except Exception, ex:
            straw.hig_alert.reportError(_("Export Error"),
                                        _("%s") % ex)

    def import_subscriptions(self):
        filename = self.get_filename()

        try:
            straw.main.import_opml(filename, self._category)
        except Exception, ex:
            straw.hig_alert.reportError(_("Unable to import subscriptions"),
                                        (_("Error occurred while reading file: %s") % ex))

    def label_set_text(self, text):
        self._label.set_text(text)

    def select_category(self, category, *args):
        self._category = category

def subscriptions_export():
    title = _("Export Subscriptions")
    fsd = FileSelectionDialog(title, file_ops=True)
    fsd.label_set_text(_("Select category to export"))

    response = fsd.run()
    if response == gtk.RESPONSE_OK:
        fsd.export_subscriptions()
    fsd.hide()

def subscriptions_import():
    title = _("Import Subscriptions")
    fsd = FileSelectionDialog(title, file_ops=False)
    fsd.label_set_text(_("Add subscriptions in"))

    response = fsd.run()
    if response == gtk.RESPONSE_OK:
        fsd.import_subscriptions()
    fsd.hide()

