module higher-order-arg
imports list-cons

strategies

  implode-string = ?x; prim("SSL_implode_string", x)
  explode-string = ?x; prim("SSL_explode_string", x)

  escape(esc : List(String) * (List(String) -> List(String)) -> List(String) ) = 
    explode-string;
    rec x(esc(x) <+ [id | x] <+ []);
    implode-string

  cify = escape(Cify)

rules

  Cify(x) : [39 | cs] -> [95, 112, 95 | <x>cs]
  Cify(x) : [45 | cs] -> [95          | <x>cs]
  Cify(x) : [95 | cs] -> [95, 95      | <x>cs]

strategies

  main = 
    <cify> "a-b_c'" => "a_b__c_p_"
