#pragma once

namespace code {

	/**
	 * Describes a stack frame in a relatively machine-independent manner. Only attempts to describe
	 * enough for stack-unwinding to work.
	 *
	 * Not exposed to Storm as we can not allocate objects on Storm:s heap when exceptions are being
	 * handled.
	 */
	class StackFrame : NoCopy {
	public:
		StackFrame(Nat block, Nat activation);

		// Currently active block and activation.
		Nat block;
		Nat activation;

		// Compute the offset of the variable, given the offset found in the metadata table.
		virtual void *toPtr(int offset) = 0;
	};


	/**
	 * Description, generated by the back-ends, of how a variable should be cleaned up.
	 */
	struct VarCleanup {
		// Cleanup function to call.
		void *function;

		// Stack offset.
		int offset;

		// Valid after the n:th activate op (counting the start of the listing as the first).
		nat activeAfter;
	};

}
