/*
    CalcModel.h
    file part of Stepulator
    a RPN calculator for *step
    
    Riccardo Mottola, 2003-2004 <rmottola@users.sf.net>
    
    This file is released under the BSD license, read acclosed License file
*/

#import <AppKit/AppKit.h>

#import <math.h>

@interface CalcModel : NSObject
{
    @private double regX;
    @private double regY;
    @private double regZ;
    @private double regT;
}
- (void)dumpRegs;
- (double)getRegX;
- (void)setRegX:(double)x;
- (void)pushRegister;
- (double)popRegister;
- (void)rotateRegister;
- (void)doSwapXY;
- (void)doAdd;
- (void)doSubtract;
- (void)doMultiply;
- (void)doDivide;
- (void)doSqrt;
- (void)doSqr;
- (void)doSin;
- (void)doCos;
- (void)doTan;
- (void)doASin;
- (void)doACos;
- (void)doATan;
- (void)doExp;
- (void)doLn;
- (void)doExp10;
- (void)doLog;
- (void)doXPowY;
- (void)doXRootY;
- (void)doInv;
- (void)doPercent;
- (void)doFact;
@end
