/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __OBJECT__
#define __OBJECT__

#include <glib.h>

/* describes what is in the extra data appended at the end of catalogs.
 * All values are in floating point.  Non-described data can be used in any 
 * way, however. */

extern GList *classlist;

struct classextension
{
	char *name;
	char *units;
	int offset;
	float defaultmin, defaultmax;
	float min[4], max[4];
};

struct classheader
{
	int numext;
	char *class;
	char *fullname;
	struct classextension *extensions;
	int magoffset;		/* magoffset < 0 if in the main obj */
	int hasmag;
	int classmask;
	float defmagmin, defmagmax;
	float magmin[4], magmax[4];
};

/* mag = (Magnutude+2.0)*10.0 */

struct object
{
        long x, y, z;
        unsigned char type, icon, mask, mag;
};

/*	mask bits:
	7	Non-existent object flag
	6
	5
	4
	3	Window 3 display mask
	2	Window 2 display mask
	1	Window 1 display mask
	0	Window 0 display mask
*/

// Precess obj by deltat years into the future

void getobjradec(struct object *obj, double *ra, double *dec);

void precess(struct object *obj, double deltat);

int maxclassnumext();

void initextension(struct classextension *e, const char *name, 
	const char *units, int offset, float defmin, float defmax);

void setclassdefaults(int viewerid);

int loadclassheaders(const char *filename);

struct classheader *getclassheader(const char *key);

void destroyclassheaders();

#endif
