#include <string.h>
#include <sys/stat.h>

#include <gtk/gtk.h>

static GtkWidget *filename_entry;
static GtkTextBuffer *text_view_buffer;

struct _worditem
{
	gchar *word;
	gchar *definition;
};

gint stardict_strcmp(const gchar *s1, const gchar *s2)
{
	gint a;
	a = g_ascii_strcasecmp(s1, s2);
	if (a == 0)
		return strcmp(s1, s2);
	else
		return a;
}

gint comparefunc(gconstpointer a,gconstpointer b)
{
	return stardict_strcmp(((struct _worditem *)a)->word,((struct _worditem *)b)->word);
}

void my_strstrip(char *str, glong linenum)
{
	char *p1, *p2;
	p1=str;
	p2=str;
	while (*p1 != '\0') {
		if (*p1 == '\\') {
			p1++;
			if (*p1 == 'n') {
				*p2='\n';
				p2++;
				p1++;
				continue;
			}
			else if (*p1 == 'r') {
				gchar *str = g_strdup_printf("Warining: line %ld \\r\n", linenum);
				gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
				g_free(str);
				p1++;
				continue;
			}
			else if (*p1 == '\\') {
				gchar *str = g_strdup_printf("Warining: line %ld \\\\\n", linenum);
				gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
				g_free(str);
				*p2='\\';
				p2++;
				p1++;
				continue;
			}
			else if (*p1 == '\0') {
				gchar *str = g_strdup_printf("Big warining: line %ld end by \\\n", linenum);
				gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
				g_free(str);
				*p2='\\';
				p2++;
				continue;
			}
			else {
				gchar *str = g_strdup_printf("Warining: line %ld \\%c\n", linenum, *p1);
				gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
				g_free(str);
				*p2='\\';
				p2++;
				*p2=*p1;
				p2++;
				p1++;
				continue;
			}
		}
		else {
			*p2 = *p1;
			p2++;
			p1++;
			continue;
		}
	}
	*p2 = '\0';
}

void convert(const char *filename)
{			
	struct stat stats;
	if (stat (filename, &stats) == -1)
	{
		gtk_text_buffer_insert_at_cursor(text_view_buffer, "File not exist!\n", -1);
		return;
	}
	gchar *basefilename = g_path_get_basename(filename);
	gchar *ch = strrchr(basefilename, '.');
	if (ch)
		*ch = '\0';
	gchar *dirname = g_path_get_dirname(filename);
	FILE *tabfile;
	tabfile = fopen(filename,"r");

	gchar *buffer = (gchar *)g_malloc (stats.st_size + 1);
	size_t readsize = fread (buffer, 1, stats.st_size, tabfile);
	fclose (tabfile);
	buffer[readsize] = '\0';
	
	GArray *array = g_array_sized_new(FALSE,FALSE, sizeof(struct _worditem), 0);

	gchar *p, *p1, *p2;
	p = buffer;
	if ((guchar)*p==0xEF && (guchar)*(p+1)==0xBB && (guchar)*(p+2)==0xBF) // UTF-8 order characters.
		p+=3;
	struct _worditem worditem;
	glong linenum=1;
	while (1) {
		if (*p == '\0') {
                        gtk_text_buffer_insert_at_cursor(text_view_buffer, "Convert over\n", -1);
                        break;
                }
		p1 = strchr(p,'\n');
		if (!p1) {
			gtk_text_buffer_insert_at_cursor(text_view_buffer, "Error, no new line at the end\n", -1);
			return;
		}
		*p1 = '\0';
		p1++;
		p2 = strchr(p,'\t');
		if (!p2) {
			gchar *str = g_strdup_printf("Error, no tab, line %ld\n", linenum);
			gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
			g_free(str);
			return;
		}
		*p2 = '\0';
		p2++;
		worditem.word = p;
		worditem.definition = p2;
		my_strstrip(worditem.definition, linenum);
		g_strstrip(worditem.word);
		g_strstrip(worditem.definition);
		if (!worditem.word[0]) {
			gchar *str = g_strdup_printf("Warning: line %ld, bad word!\n", linenum);
			gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
			g_free(str);
			p= p1;
			linenum++;
			continue;
		}
		if (!worditem.definition[0]) {
			gchar *str = g_strdup_printf("Warning: line %ld, bad definition!\n", linenum);
			gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
			g_free(str);
			p= p1;
			linenum++;
			continue;
		}
		g_array_append_val(array, worditem);			
		p= p1;				
		linenum++;
	}		
	g_array_sort(array,comparefunc);

	gchar ifofilename[256];
	gchar idxfilename[256];
	gchar dicfilename[256];
	sprintf(ifofilename, "%s\\%s.ifo", dirname, basefilename);
	sprintf(idxfilename, "%s\\%s.idx", dirname, basefilename);
	sprintf(dicfilename, "%s\\%s.dict", dirname, basefilename);
	FILE *ifofile = fopen(ifofilename,"wb");
	if (!ifofile) {
		gtk_text_buffer_insert_at_cursor(text_view_buffer, "Write to ifo file failed!\n", -1);
		return;
	}
	FILE *idxfile = fopen(idxfilename,"wb");
	if (!idxfile) {
		gtk_text_buffer_insert_at_cursor(text_view_buffer, "Write to idx file failed!\n", -1);
		return;
	}
	FILE *dicfile = fopen(dicfilename,"wb");
	if (!dicfile) {
		gtk_text_buffer_insert_at_cursor(text_view_buffer, "Write to dict file failed!\n", -1);
		return;
	}

	
	glong wordcount = array->len;

	long offset_old;
	glong tmpglong;
	gchar *previous_word = "";
	struct _worditem *pworditem;
	gulong i=0;
	glong thedatasize;
	gchar *insert_word = "\n\n";
	gboolean flag;
	pworditem = &g_array_index(array, struct _worditem, i);
	gint definition_len;
	while (i<array->len)
	{
		thedatasize = 0; 
		offset_old = ftell(dicfile);
		flag = true;
		while (flag == true)
		{	
			definition_len = strlen(pworditem->definition);
			fwrite(pworditem->definition, 1 ,definition_len,dicfile);
			thedatasize += definition_len;
			previous_word = pworditem->word;
						
			i++;
			if (i<array->len)
			{
				pworditem = &g_array_index(array, struct _worditem, i);
				if (strcmp(previous_word,pworditem->word)==0)
				{
					gtk_text_buffer_insert_at_cursor(text_view_buffer, "Duplicate word: ", -1);
					gtk_text_buffer_insert_at_cursor(text_view_buffer, previous_word, -1);
					gtk_text_buffer_insert_at_cursor(text_view_buffer, "\n", -1);
					flag = true;
					wordcount--;
					fwrite(insert_word,sizeof(gchar),strlen(insert_word),dicfile);
					thedatasize += strlen(insert_word);
				}
				else 
				{
					flag = false;
				}
			}
			else
			{
				flag = false;
			}
		}
		fwrite(previous_word,sizeof(gchar),strlen(previous_word)+1,idxfile);
		tmpglong = g_htonl(offset_old);
		fwrite(&(tmpglong),sizeof(glong),1,idxfile);
		tmpglong = g_htonl(thedatasize);
		fwrite(&(tmpglong),sizeof(glong),1,idxfile);	
	}	
	
	gchar *str = g_strdup_printf("%s wordcount: %ld\n", basefilename, wordcount);
	gtk_text_buffer_insert_at_cursor(text_view_buffer, str, -1);
	g_free(str);
	
	g_free(buffer);
	g_array_free(array,TRUE);
	
	fclose(idxfile);
	fclose(dicfile);

	/*gchar command[256];
	sprintf(command, "dictzip %s\\%s.dict", dirname, basefilename);
	system(command);*/

	stat(idxfilename, &stats);
	fprintf(ifofile, "StarDict's dict ifo file\nversion=2.4.2\nwordcount=%ld\nidxfilesize=%ld\nbookname=%s\nsametypesequence=m\n", wordcount, stats.st_size, basefilename);
	fclose(ifofile);
	
	g_free(basefilename);
	g_free(dirname);
}

void on_build_button_clicked(GtkButton *button, gpointer data)
{
	gtk_text_buffer_set_text(text_view_buffer, "Building...\n", -1);
	convert(gtk_entry_get_text(GTK_ENTRY(filename_entry)));
	gtk_text_buffer_insert_at_cursor(text_view_buffer, "Done!\n", -1);
}

gboolean on_delete_event(GtkWidget * window, GdkEvent *event , gpointer data)
{
	gtk_main_quit();
	return FALSE;
}

void on_exit_button_clicked(GtkButton *button, gpointer data)
{
	gtk_main_quit();	
}

void on_browse_button_clicked(GtkButton *button, gpointer data)
{
	GtkWindow *window = GTK_WINDOW(data);
	GtkWidget *dialog;
	dialog = gtk_file_chooser_dialog_new ("Open file...",
			window,
			GTK_FILE_CHOOSER_ACTION_OPEN,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
			NULL);
	gtk_file_chooser_set_filename(GTK_FILE_CHOOSER (dialog), gtk_entry_get_text(GTK_ENTRY(filename_entry)));
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		gchar *filename;
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_entry_set_text(GTK_ENTRY(filename_entry), filename);
		g_free (filename);
	}
	gtk_widget_destroy (dialog);
}

int main(int argc,char **argv)
{
	gtk_set_locale();
	gtk_init(&argc, &argv);
	GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (on_delete_event), NULL);
	GtkWidget *vbox = gtk_vbox_new(false, 6);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	GtkWidget *hbox = gtk_hbox_new(false, 6);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, false, false, 0);
	GtkWidget *label = gtk_label_new("File name:");
	gtk_box_pack_start(GTK_BOX(hbox), label, false, false, 0);
	filename_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), filename_entry, false, false, 0);
	GtkWidget *button = gtk_button_new_with_mnemonic("Bro_wse...");
	gtk_box_pack_start(GTK_BOX(hbox), button, false, false, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(on_browse_button_clicked), window);
	label = gtk_label_new("This file should be encoded in UTF-8!");
	gtk_box_pack_start(GTK_BOX(vbox), label, false, false, 0);
	GtkWidget *text_view = gtk_text_view_new();
	gtk_widget_set_size_request(text_view, -1, 150);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text_view), GTK_WRAP_WORD_CHAR);
	text_view_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text_view));
    gtk_text_buffer_set_text(text_view_buffer,
		"Here is a example dict.tab file:\n"
		"============\n"
		"a\t1\\n2\\n3\n"
		"b\t4\\\\5\\n6\n"
		"c\t789\n"
		"============\n"
		"It means: write the search word first, then a Tab character, and the definition. If the definition contains new line, just write \\n, if contains \\ character, just write \\\\.\n"
		, -1);
	GtkWidget *scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_window), text_view);
	gtk_box_pack_start(GTK_BOX(vbox), scrolled_window, false, false, 0);
	hbox = gtk_hbox_new(false, 6);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, false, false, 0);
	button = gtk_button_new_with_mnemonic("_Build");
	gtk_box_pack_start(GTK_BOX(hbox), button, false, false, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(on_build_button_clicked), NULL);
	button = gtk_button_new_with_mnemonic("E_xit");
	gtk_box_pack_start(GTK_BOX(hbox), button, false, false, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(on_exit_button_clicked), NULL);
	gtk_widget_show_all(window);
	gtk_main();
	return 0;
}
