#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "stardict.h"
#include "conf.h"

#include "splash.h"


// this is the callback which will destroy the splash screen window.
static void
splash_screen_cb(gpointer data)
{
	gtk_widget_destroy(GTK_WIDGET(data));
}

void show_splash_screen()
{		
	gtk_window_set_auto_startup_notification(false);

	GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file((gStarDictDataDir+G_DIR_SEPARATOR+"pixmaps"+G_DIR_SEPARATOR+"splash.png").c_str(), NULL);

	gint w = gdk_pixbuf_get_width(pixbuf);
	gint h = gdk_pixbuf_get_height(pixbuf);
	
	GtkWidget *window = gtk_window_new (GTK_WINDOW_POPUP);

	gtk_widget_set_app_paintable(window, true);
	gtk_window_set_title (GTK_WINDOW (window), _("StarDict"));
	gtk_window_set_position(GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_widget_set_size_request(window, w, h);
	gtk_widget_show(window);
	
	GdkPixmap *pixmap = gdk_pixmap_new (window->window, w, h, -1);
	gdk_pixbuf_render_to_drawable (pixbuf, pixmap,
				       window->style->fg_gc[GTK_STATE_NORMAL],
				       0, 0, 0, 0, w,
				       h, GDK_RGB_DITHER_NORMAL, 0, 0);
	
	gdk_window_set_back_pixmap (window->window, pixmap, FALSE);
	gdk_window_clear (window->window);
	g_object_unref(pixbuf);
	g_object_unref(pixmap);

	// go into main loop, processing events.
	while(gtk_events_pending())
		gtk_main_iteration();

	// it will be called after gtk_main() is called.
	gtk_init_add ((GtkFunction)splash_screen_cb, (gpointer)window);
	
	gtk_window_set_auto_startup_notification(true);
}
