#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <cstdlib>
#include <cstring>

#include "stardict.h"
#include "conf.h"

#include "skin.h"

_Skin_cursor::_Skin_cursor()
{
	cursor=NULL;
}

_Skin_cursor::~_Skin_cursor()
{
	if (cursor)
		gdk_cursor_unref(cursor);
}

_Skin_pixbuf_1::_Skin_pixbuf_1()
{
	for (int i=0;i<1;i++)
		p[i]=NULL;
}

_Skin_pixbuf_1::~_Skin_pixbuf_1()
{
	for (int i=0;i<1;i++)
	{
		if (p[i])
			g_object_unref(p[i]);
	}
}

AppSkin::AppSkin()
{
}

void AppSkin::load()
{		
	stardict.normal_cursor.cursor=(GdkCursor *)NULL; // NULL is the default cursor.
	stardict.watch_cursor.cursor= gdk_cursor_new(GDK_WATCH);
  std::string pixmaps_dir(gStarDictDataDir+G_DIR_SEPARATOR+"pixmaps"+G_DIR_SEPARATOR);
  std::string filename;
#ifdef _WIN32			
  filename=pixmaps_dir+"stardict.png";
  stardict.icon.p[0] = gdk_pixbuf_new_from_file(filename.c_str(), NULL);
#else
  stardict.icon.p[0] = gdk_pixbuf_new_from_file(GNOME_ICONDIR"/stardict.png", NULL);	
  filename=pixmaps_dir+"docklet_normal.png";
  stardict.docklet_normal_icon.p[0] = gdk_pixbuf_new_from_file(filename.c_str(), NULL);
  filename=pixmaps_dir+"docklet_scan.png";
  stardict.docklet_scan_icon.p[0] = gdk_pixbuf_new_from_file(filename.c_str(), NULL);
  filename=pixmaps_dir+"docklet_stop.png";
  stardict.docklet_stop_icon.p[0] = gdk_pixbuf_new_from_file(filename.c_str(), NULL);
#endif
  filename=pixmaps_dir+"index_wazard.png";
  stardict.index_wazard.p[0] = gdk_pixbuf_new_from_file(filename.c_str(), NULL);
  filename=pixmaps_dir+"index_appendix.png";
  stardict.index_appendix.p[0] = gdk_pixbuf_new_from_file(filename.c_str(), NULL);
}
