#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "winconf.h"
#include "../stardict.h"
#include "intl.h"

#include <cstdio>
#include <cstdlib>
#include <sys/stat.h>

// Notice: once you changed this file, try to change src/conf.cpp too.

ConfigFile *usercfgfile;

void init_conf()
{
	struct stat st;
	gchar *filename = g_build_filename(stardict_data_dir, "stardict.cfg", NULL);
	if (stat (filename, &st))
	{
		FILE *file;
		if ((file = fopen (filename, "wb")) == NULL) {
			g_free(filename);
			return;
		}
		fprintf (file, "[preferences/dictionary]\n"
  							"scan_selection=1\n"
							"only_scan_while_modifier_key=0\n"
							"hide_floatwin_when_modifier_key_released=1\n"
							"scan_modifier_key=0\n"
							"enable_sound_event=1\n"
							
		);
		fprintf (file, _("use_custom_font=1\ncustom_font=sans 8\n"));
		fprintf (file, "[preferences/main_window]\n"
							"hide_on_startup=0\n"
							"search_website_list=\n"
							"maximized=0\n"
							"hide_list=0\n"
		);
		fprintf (file, _("window_width=551\nwindow_height=357\nhpaned_pos=165\n"));
		fprintf (file, "[preferences/notification_area_icon]\n"
							"query_in_floatwin=1\n"
		);
		fprintf (file, "[preferences/floating_window]\n"
							"pronounce_when_popup=0\n"
							"max_window_width=320\n"
							"max_window_height=240\n"
							"lock=0\n"
							"lock_x=0\n"
							"lock_y=0\n"
		);
		fprintf (file, "[manage_dictionaries]\n"
							"dict_order_list=\n"
							"dict_disable_list=\n"
							"treedict_order_list=\n"
							"treedict_disable_list=\n"
		);
		fclose (file);
	}
	usercfgfile = rw_cfg_open_file (filename);
	g_free(filename);
}

void save_conf()
{
	if (usercfgfile->changed)
		rw_cfg_write_file(usercfgfile,usercfgfile->cfgfilename);
	rw_cfg_free (usercfgfile);
	g_free (usercfgfile);
}

void on_conf_dictionary_scan_selection_changed(gboolean scan)
{
	if (gpAppFrame->oAppCore.oSelection.bEnable == scan)
		return;
	gpAppFrame->oAppCore.oSelection.bEnable = scan;
	gtk_widget_set_sensitive(gpAppFrame->oAppCore.oFloatWin.StopButton, scan);
	if 	(scan != gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gpAppFrame->oAppCore.oBottomWin.ScanSelectionCheckButton))) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(gpAppFrame->oAppCore.oBottomWin.ScanSelectionCheckButton),scan);
	}		
	if (scan) {
		if (!GTK_WIDGET_VISIBLE(gpAppFrame->oAppCore.window)) {
			gpAppFrame->oAppCore.oDockLet.SetIcon(DOCKLET_SCAN_ICON);
		}
		if (gpAppFrame->oAppCore.oFloatWin.bIsLocked && (gpAppFrame->oAppCore.oFloatWin.QueryingWord.c_str())[0]!='\0')
			gpAppFrame->oAppCore.oFloatWin.Show();
	}
	else {
		if (!GTK_WIDGET_VISIBLE(gpAppFrame->oAppCore.window)) {
			gpAppFrame->oAppCore.oDockLet.SetIcon(DOCKLET_STOP_ICON);
		}
		gpAppFrame->oAppCore.oFloatWin.Hide();
		gpAppFrame->oAppCore.oSelection.LastClipWord.clear();
	}
}

void on_conf_dictionary_only_scan_while_modifier_key_changed(gboolean only_scan)
{  
	gpAppFrame->oAppCore.oSelection.only_scan_while_modifier_key = only_scan;
}

void on_conf_dictionary_hide_floatwin_when_modifier_key_released_changed(gboolean hide)
{
	gpAppFrame->oAppCore.oFloatWin.hide_floatwin_when_modifier_key_released = hide;
}

void on_conf_dictionary_scan_modifier_key_changed(gint key)
{
	gpAppFrame->oAppCore.oSelection.scan_modifier_key = key;
}

void on_conf_dictionary_enable_sound_event_changed(gboolean enable)
{
	gpAppFrame->enable_sound_event = enable;
}

void on_conf_main_window_searchwebsite_list_changed(GSList *list)
{
	g_slist_foreach (gpAppFrame->oAppCore.oBottomWin.searchwebsite_list, (GFunc)g_free, NULL);
	g_slist_free (gpAppFrame->oAppCore.oBottomWin.searchwebsite_list);
	gpAppFrame->oAppCore.oBottomWin.searchwebsite_list = list;
}

void on_conf_main_window_hide_list_changed(gboolean hide)
{
	if (hide) {
		gtk_widget_hide(gpAppFrame->oAppCore.oMidWin.oToolWin.HideListButton);
		gtk_widget_show(gpAppFrame->oAppCore.oMidWin.oToolWin.ShowListButton);
		gtk_widget_hide(gpAppFrame->oAppCore.oMidWin.oIndexWin.vbox);
	}
	else {
		gtk_widget_hide(gpAppFrame->oAppCore.oMidWin.oToolWin.ShowListButton);
		gtk_widget_show(gpAppFrame->oAppCore.oMidWin.oToolWin.HideListButton);
		gtk_widget_show(gpAppFrame->oAppCore.oMidWin.oIndexWin.vbox);
	}
}

void on_conf_notification_area_icon_show_in_floatwin_changed(gboolean query_in_floatwin)
{
	gpAppFrame->oAppCore.oDockLet.query_in_floatwin = query_in_floatwin;
}

void on_conf_floatwin_pronounce_when_popup_changed(gboolean pronounce_when_popup)
{
	gpAppFrame->oAppCore.oFloatWin.pronounce_when_popup = pronounce_when_popup;
}

void on_conf_floatwin_max_window_width_changed(gint width)
{
	gpAppFrame->oAppCore.oFloatWin.Window_max_width = width;
}

void on_conf_floatwin_max_window_height_changed(gint height)
{
	gpAppFrame->oAppCore.oFloatWin.Window_max_height = height;
}

void on_conf_floatwin_lock_changed(gboolean lock)
{
	gpAppFrame->oAppCore.oFloatWin.bIsLocked = lock;
	if (lock)
		gtk_image_set_from_stock(GTK_IMAGE(gpAppFrame->oAppCore.oFloatWin.lock_image),GTK_STOCK_GOTO_LAST,GTK_ICON_SIZE_MENU);
	else
		gtk_image_set_from_stock(GTK_IMAGE(gpAppFrame->oAppCore.oFloatWin.lock_image),GTK_STOCK_GO_FORWARD,GTK_ICON_SIZE_MENU);
}
