/* @(#)dumpdate.h	1.6 04/10/10 Copyright 2003 J. Schilling */
/*
 *	Copyright (c) 2003 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef	DUMPDATE_H
#define	DUMPDATE_H

#ifndef	TIMEDEFS_H
#include <timedefs.h>
#endif
#ifndef	UTYPES_H
#include <utypes.h>
#endif

typedef struct dumpdates dumpd_t;

struct dumpdates {
	dumpd_t		*next;
	char		*name;
	int		level;
	struct timeval	date;
	Uchar		flags;
};

/*
 * Definitions for the dumpdates 'flags'.
 */
#define	DD_PARTIAL	0x01	/* Dump is partial */


extern	void	initdumpdates	__PR((char *fname));
extern	void	writedumpdates	__PR((char *fname, int level, int dflags,
							struct timeval *date));
extern	char	*dumpdate	__PR((struct timeval *date));
extern	BOOL	getdumptime	__PR((char *p, struct timeval *tvp));
extern	dumpd_t *checkdumpdates	__PR((const char *name, int level, int dflags));
extern	void	adddumpdates	__PR((const char *name, int level, int dflags,
							struct timeval *date,
								BOOL useold));

#endif
