.TH "srg" 1
.SH NAME
srg \- A fast and flexible log analyser for the Squid proxy
.SH SYNOPSIS
.B srg
srg [options] <logfile> [logfile] ...
.SH DESCRIPTION
SRG is a log analyser for the Squid web proxy. SRG takes input in the form
of Squid access logs and outputs a series of reports in PHP (or HTML) format
designed to summarise what the users of the cache have been viewing. SRG 
supports grouping requests by user, subnet or IP and can also filter on the
same criteria.
.SH OPTIONS
.TP
.B \-C <config file>
Location of the srg config file.
.TP
.B \-d 
Enable debugging output
.TP
.B \-f <date>[time]
Start time to begin analysation at
.TP
.B \-\-help \-h
Display this help
.TP
.B \-H
Generate HTML rather than PHP reports
.TP
.B \-m <days>
Specify maximum number of days to keep a report
.TP
.B \-M
Output a summary report suitable for emailing.
.TP
.B \-o <directory>
Output Directory
.TP
.B \-O <URL>
URL where reports will be located
.TP
.B \-t <date>[time]
End time to stop analysation at
.TP
.B \-v
Verbose mode. Print relevant messages.
.TP
.B \-V
Print Version and exit.
.P
Date and time should be specified in the following format for \-f and \-t
.P
 Date: YYYY\-MM\-DD
 Time: :HH:MM:SS \- note leading :
 eg. 2005\-01\-08:15:46:30 (Jan 8 2005 15:46:30)
.P
Logfile(s) to process should be specified at the end of the options
.SH AUTHOR
SRG is written and maintained by Matt Brown <matt@crc.net.nz> with the help
of many others. See AUTHORS in the top level of the source tree.
.SH BUGS
Of course SRG doesn't have any bugs *wink*, if by some obscure chance you 
happen to find a bug in SRG, please report it via the URL below

.B http://sourceforge.net/tracker/?func=add&group_id=62787&atid=501794
