/*
	SRG - Squid Report Generator
	Prototypes header
	Copyright 2005 University of Waikato

	This file is part of SRG.

	SRG is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	SRG is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with SRG; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef PROTOTYPES_H
#define PROTOTYPES_H

/* Function Prototypes */
bool do_configuration(int argc, char **argv);
void usage(void);
void set_defaults(void); 
int parse_line(char * , log_line *);
void print_line(const log_line *line);
void generate_email_report(void);
void process_logs(void);
int process_log(const char *filename);
int process_line(const log_line *line);
bool is_cache_hit(const char * resultCode);
bool is_cache_denied(const char * resultCode);
bool isInSubnet(const in_addr clientAddress, const in_addr networkAddress, 
		const in_addr netmask);
void getNetworkAddress(const in_addr clientAddress, const in_addr netmask, 
		in_addr *network);
void generate_reports(const char *basedir);
char * cleanseStr(char *);
char * FormatOutput(unsigned long long);
void make_date_index();
void recurse_unlink(const char *);
void cull_oldreports(int);
void init_ip2user(void);
bool ip2username(const in_addr, char **);
char * md5this(const char *);
int shortmonth2int(const char *);
int getMonthByName(const char *name);
char *break_string(char *string, char delim);
char *asprintURL(url_request *req);
int parseURL(const char*URL, url_request *req);
void freeURL(url_request *req);
char *generate_datename(const time_t start, const time_t end);
time_t parse_timestring(const char *tstring);
void html_header(FILE *outfile, const char *rootpath);
void html_footer(FILE *outfile, const char *rootpath);
int compare_datename(const char *date1, const char *date2);
int compare_datepart(const char *date1, const char *date2);
void check_environment(void);
void get_file_version(const char *filename, const char *versionkey, 
		char *fileversion, int fvlen);
int file_present(const char *filename, const char *versionkey);
void init_file(const char *filename);


inline bool isInSubnet(const in_addr clientAddress,
		const in_addr networkAddress, const in_addr netmask) {
	return ((clientAddress.s_addr&netmask.s_addr)==
			(networkAddress.s_addr&netmask.s_addr));
}

/* External Variables */
extern "C" time_t get_date (const char *p, const time_t *now);
extern char *month_names[];
extern Resolver *dnscache;
extern config_info srg;
extern char *progname;
extern char *version;
extern char *cvsid;

#endif // PROTOTYPES_H
