<?php

/**
 * BEFORE EDITING THIS FILE!
 *
 * Don't edit this file directly.  Copy it to config.php before you
 * edit it.  However, it is best to use the configuration script
 * conf.pl if at all possible.  That is the easiest and cleanest way
 * to configure.
 */

/* Do not change this value. */
global $version;
global $config_version;
$config_version = '1.4.0';

/*** Organization preferences ***/
/**
 * Organization's name
 */
$org_name = "SquirrelMail";

/**
 * Organization's logo picture (blank if none)
 */
$org_logo = SM_PATH . 'images/sm_logo.png';

/**
 * The width of the logo (0 for default)
 */
$org_logo_width = '308';

/**
 * The height of the logo (0 for default)
 */
$org_logo_height = '111';

/**
 * Webmail Title
 *   This is the web page title that appears at the top of the browser window.
 */
$org_title = "SquirrelMail $version";

/**
 * Rather than going to the signout.php page (which only allows you
 * to sign back in), setting signout_page allows you to sign the user
 * out and then redirect to whatever page you want. For instance,
 * the following would return the user to your home page:
 *   $signout_page = '/';
 * Set to the empty string to continue to use the default signout page.
 */
$signout_page = '';

/**
 * By default SquirrelMail takes up the whole browser window,
 * this allows you to embed it within sites using frames. Set
 * this to the frame you want it to stay in.
 */
$frame_top = '_top';

/**
 * Here you can set link displayed on the right side of main page.
 * $provider_name sets name of link
 * $provider_url set address used in the link
 *
 * Link will be displayed only if you have $hide_sm_attributions 
 * option set to true.
 */
$provider_name = 'SquirrelMail';
$provider_uri = 'http://www.squirrelmail.org/';


/*** Server Settings ***/
/**
 * The domain part of local email addresses.
 *   This is for all messages sent out from this server.
 *   Reply address is generated by $username@$domain
 * Example: In bob@foo.com, foo.com is the domain.
 */
$domain = 'example.com';

/**
 * If you are running on a machine that doesn't have the tm_gmtoff
 * value in your time structure and if you are in a time zone that
 * has a negative offset, you need to set this value to 1. This is
 * typically people in the US that are running Solaris 7.
 */
$invert_time = false;

/**
 * What should be used when sending email.
 * If it is set to false, SquirrelMail will use SMTP server settings.
 * If it is set to true, SquirrelMail will use program defined in 
 * $sendmail_path
 */
$useSendmail = false;

/**
 * Your SMTP server and port number (usually the same as the IMAP server).
 */
$smtpServerAddress = 'localhost';
$smtpPort = 25;

/**
 * Program that should be used when sending email. SquirrelMail expects that
 * this program will follow options used by original sendmail 
 * (http://www.sendmail.org).
 */
$sendmail_path = '/usr/sbin/sendmail';
    
/**
 * The dns name (or IP address) and port for your imap server.
 */
$imapServerAddress = 'localhost';
$imapPort = 143;

/**
 * The type of IMAP server you are running.
 * Valid type are the following (case is important):
 *   courier
 *   cyrus
 *   exchange
 *   uw
 *   macosx
 *   mercury32
 *   other
 *
 * Please note that this changes only some of server settings.
 *
 * In order to set everything correctly, you need to adjust several
 * squirrelmail options. These options are listed in doc/presets.txt
 */
$imap_server_type = 'other';

/**
 * Advanced authentication options
 * CRAM-MD5, DIGEST-MD5, Plain, and TLS
 * Set reasonable defaults - you'd never know this was there unless you ask for it
 */
$use_imap_tls = false;
$use_smtp_tls = false;

/**
 * auth_mech can be either 'login','plain', 'cram-md5', or 'digest-md5'
 *  SMTP can also be 'none'
 */
$smtp_auth_mech = 'none';
$imap_auth_mech = 'login';

/**
 * This is the delimiter that your IMAP server uses to distinguish between
 * folders.  For example, Cyrus uses '.' as the delimiter and a complete
 * folder would look like 'INBOX.Friends.Bob', while UW uses '/' and would
 * look like 'INBOX/Friends/Bob'.  Normally this should be left at 'detect'
 * but if you are sure you know what delimiter your server uses, you can
 * specify it here.
 *
 * To have it autodetect the delimiter, set it to 'detect'.
 */
$optional_delimiter = 'detect';

/**
 * Do you wish to use POP3 before SMTP?  Your server must
 * support this in order for SquirrelMail to work with it.
 */
$pop_before_smtp = false;


/*** Folder Settings ***/
/**
 * Many servers store mail in your home directory. With this, they
 * store them in a subdirectory: mail/ or Mail/, etc. If your server
 * does this, please set this to what the default mail folder should
 * be. This is still a user preference, so they can change it if it
 * is different for each user.
 *
 * Example:
 *     $default_folder_prefix = 'mail/';
 *        -- or --
 *     $default_folder_prefix = 'Mail/folders/';
 *
 * If you do not use this, set it to the empty string.
 */
$default_folder_prefix = '';

/**
 * If you do not wish to give them the option to change this, set it
 * to false. Otherwise, if it is true, they can change the folder prefix
 * to be anything.
 */
$show_prefix_option = false;

/**
 * The following are related to deleting messages.
 *   $default_move_to_trash
 *      If this is set to 'true', when 'delete' is pressed, it
 *      will attempt to move the selected messages to the folder
 *      named $trash_folder. If it's set to 'false', we won't even
 *      attempt to move the messages, just delete them.
 *   $default_move_to_sent
 *      If this is set to 'true', sent messages will be stored in
 *      $sent_folder by default.
 *   $default_save_as_draft
 *      If this is set to 'true', users are able to use $draft_folder
 *      to store their unfinished messages.
 *   $trash_folder
 *      This is the path to the default trash folder. For Cyrus
 *      IMAP, it would be 'INBOX.Trash', but for UW it would be
 *      'Trash'. We need the full path name here.
 *   $draft_folder
 *      This is the patch to where Draft messages will be stored.
 *   $auto_expunge
 *      If this is true, when a message is moved or copied, the
 *      source mailbox will get expunged, removing all messages
 *      marked 'Deleted'.
 *   $sent_folder
 *      This is the path to where Sent messages will be stored.
 *   $delete_folder
 *      If this is true, when a folder is deleted then it will
 *      not get moved into the Trash folder.
 */
$default_move_to_trash = true;
$default_move_to_sent  = true;
$default_save_as_draft = true;
$trash_folder = 'INBOX.Trash';
$sent_folder  = 'INBOX.Sent';
$draft_folder = 'INBOX.Drafts';
$auto_expunge = true;
$delete_folder = false;

/**
 * Whether or not to use a special color for special folders. If not,
 * special folders will be the same color as the other folders.
 */
$use_special_folder_color = true;

/**
 * Should I create the Sent and Trash folders automatically for
 * a new user that doesn't already have them created?
 */
$auto_create_special = true;

/* Whether or not to list the special folders first (true/false). */
$list_special_folders_first = true;

/**
 * Are all your folders subfolders of INBOX (i.e. cyrus IMAP server).
 * If you are unsure, set it to false.
 */
$default_sub_of_inbox = true;

/**
 * Some IMAP daemons (UW) handle folders weird. They only allow a
 * folder to contain either messages or other folders, not both at
 * the same time. This option controls whether or not to display an
 * option during folder creation. The option toggles which type of
 * folder it should be.
 *
 * If this option confuses you, just set it to 'true'. You can not hurt 
 * anything if it's true, but some servers will respond weird if it's
 * false. (Cyrus works fine whether it's true OR false).
 */
$show_contain_subfolders_option = false;

/**
 * These next two options set the defaults for the way that the
 * users see their folder list.
 *   $default_unseen_notify
 *       Specifies whether or not the users will see the number of 
 *       unseen in each folder by default and also which folders to
 *       do this to. Valid values are: 1=none, 2=inbox, 3=all.
 *   $default_unseen_type
 *       Specifies the type of notification to give the users by
 *       default. Valid choice are: 1=(4), 2=(4,25).
 */
$default_unseen_notify = 2;
$default_unseen_type   = 1;

/**
 * This enables the no select fix for Cyrus when subfolders
 * exist but parent folders do not
 */
$noselect_fix_enable = false;

/*** General options ***/
/**
 * Path to the data/ directory
 *   It is a possible security hole to have a writable directory
 *   under the web server's root directory (ex: /home/httpd/html).
 *   For this reason, it is possible to put the data directory
 *   anywhere you would like. The path name can be absolute or
 *   relative (to the config directory). It doesn't matter. Here
 *   are two examples:
 *
 * Absolute:
 *   $data_dir = '/usr/local/squirrelmail/data/';
 *
 * Relative (to main SM directory):
 *   $data_dir = SM_PATH . 'data/';
 */
$data_dir = SM_PATH . 'data/';

/**
 * Path to directory used for storing attachments while a mail is
 * being sent. There are a few security considerations regarding
 * this directory:
 *    + It should have the permission 733 (rwx-wx-wx) to make it
 *      impossible for a random person with access to the webserver to
 *      list files in this directory. Confidential data might be laying
 *      around there.
 *    + Since the webserver is not able to list the files in the content
 *       is also impossible for the webserver to delete files lying around 
 *       there for too long.
 *    + It should probably be another directory than data_dir.
 */
$attachment_dir = $data_dir;

/**
 * Hash level used for data directory.
 * 
 * This option allows spliting file based squirrelmail user
 * data storage directory into several subfolders. Number from
 * 0 to 4 allows allows having up to four subfolder levels.
 *
 * Hashing should speed up directory access if you have big number 
 * of users (500 and more).
 */
$dir_hash_level = 0;

/**
 * This is the default size of the folder list. Default
 * is 150, but you can set it to whatever you wish.
 */
$default_left_size = '150';

/**
 * Some IMAP servers allow a username (like 'bob') to log in if they use
 * uppercase in their name (like 'Bob' or 'BOB'). This creates extra
 * preference files.  Toggling this option to true will transparently
 * change all usernames to lowercase.
 */
$force_username_lowercase = false;

/**
 * This option enables use of email priority flags by end users.
 */
$default_use_priority = true;

/**
 * This option disables display of "created by squirrelmail developers" 
 * strings and provider link
 */
$hide_sm_attributions = false;

/**
 * This option enables use of read/delivery reciepts by end users.
 */
$default_use_mdn = true;

/**
 * If you don't want to allow users to change their email address
 * then you can set $edit_identity to false, if you want them to
 * not be able to change their full name too then set $edit_name
 * to false as well. $edit_name has no effect unless $edit_identity
 * is false;
 */
$edit_identity = true;
$edit_name = true;

/**
 * If you want to enable server side thread sorting options
 * Your IMAP server must support the THREAD extension for 
 * this to work.
 */
$allow_thread_sort = false;

/** 
 * to use server-side sorting instead of SM client side.
 * Your IMAP server must support the SORT extension for this
 * to work.
 */
$allow_server_sort = false;

/**
 * This option allows you to choose if SM uses charset search
 * Your imap server should support SEARCH CHARSET command for 
 * this to work.
 */
$allow_charset_search = true;

/**
 * PHP session name.  Leave this alone unless you know what you are doing.
 */
$session_name = 'SQMSESSID';


/**
 * Themes
 *   You can define your own theme and put it in this directory.
 *   You must call it as the example below. You can name the theme
 *   whatever you want. For an example of a theme, see the ones
 *   included in the config directory.
 *
 * To add a new theme to the options that users can choose from, just
 * add a new number to the array at the bottom, and follow the pattern.
 * 
 * $theme_default sets theme that will be used by default
 * $theme_css sets stylesheet (from theme/css directory) that will be 
 * used by default.
 */
$theme_default = 0;
$theme_css = '';

$theme[0]['PATH'] = SM_PATH . 'themes/default_theme.php';
$theme[0]['NAME'] = 'Default';

$theme[1]['PATH'] = SM_PATH . 'themes/plain_blue_theme.php';
$theme[1]['NAME'] = 'Plain Blue';

$theme[2]['PATH'] = SM_PATH . 'themes/sandstorm_theme.php';
$theme[2]['NAME'] = 'Sand Storm';

$theme[3]['PATH'] = SM_PATH . 'themes/deepocean_theme.php';
$theme[3]['NAME'] = 'Deep Ocean';

$theme[4]['PATH'] = SM_PATH . 'themes/slashdot_theme.php';
$theme[4]['NAME'] = 'Slashdot';

$theme[5]['PATH'] = SM_PATH . 'themes/purple_theme.php';
$theme[5]['NAME'] = 'Purple';

$theme[6]['PATH'] = SM_PATH . 'themes/forest_theme.php';
$theme[6]['NAME'] = 'Forest';

$theme[7]['PATH'] = SM_PATH . 'themes/ice_theme.php';
$theme[7]['NAME'] = 'Ice';

$theme[8]['PATH'] = SM_PATH . 'themes/seaspray_theme.php';
$theme[8]['NAME'] = 'Sea Spray';

$theme[9]['PATH'] = SM_PATH . 'themes/bluesteel_theme.php';
$theme[9]['NAME'] = 'Blue Steel';

$theme[10]['PATH'] = SM_PATH . 'themes/dark_grey_theme.php';
$theme[10]['NAME'] = 'Dark Grey';

$theme[11]['PATH'] = SM_PATH . 'themes/high_contrast_theme.php';
$theme[11]['NAME'] = 'High Contrast';

$theme[12]['PATH'] = SM_PATH . 'themes/black_bean_burrito_theme.php';
$theme[12]['NAME'] = 'Black Bean Burrito';

$theme[13]['PATH'] = SM_PATH . 'themes/servery_theme.php';
$theme[13]['NAME'] = 'Servery';

$theme[14]['PATH'] = SM_PATH . 'themes/maize_theme.php';
$theme[14]['NAME'] = 'Maize';

$theme[15]['PATH'] = SM_PATH . 'themes/bluesnews_theme.php';
$theme[15]['NAME'] = 'BluesNews';

$theme[16]['PATH'] = SM_PATH . 'themes/deepocean2_theme.php';
$theme[16]['NAME'] = 'Deep Ocean 2';

$theme[17]['PATH'] = SM_PATH . 'themes/blue_grey_theme.php';
$theme[17]['NAME'] = 'Blue Grey';

$theme[18]['PATH'] = SM_PATH . 'themes/dompie_theme.php';
$theme[18]['NAME'] = 'Dompie';

$theme[19]['PATH'] = SM_PATH . 'themes/methodical_theme.php';
$theme[19]['NAME'] = 'Methodical';

$theme[20]['PATH'] = SM_PATH . 'themes/greenhouse_effect.php';
$theme[20]['NAME'] = 'Greenhouse Effect (Changes)';

$theme[21]['PATH'] = SM_PATH . 'themes/in_the_pink.php';
$theme[21]['NAME'] = 'In The Pink (Changes)';

$theme[22]['PATH'] = SM_PATH . 'themes/kind_of_blue.php';
$theme[22]['NAME'] = 'Kind of Blue (Changes)';

$theme[23]['PATH'] = SM_PATH . 'themes/monostochastic.php';
$theme[23]['NAME'] = 'Monostochastic (Changes)';

$theme[24]['PATH'] = SM_PATH . 'themes/shades_of_grey.php';
$theme[24]['NAME'] = 'Shades of Grey (Changes)';

$theme[25]['PATH'] = SM_PATH . 'themes/spice_of_life.php';
$theme[25]['NAME'] = 'Spice of Life (Changes)';

$theme[26]['PATH'] = SM_PATH . 'themes/spice_of_life_lite.php';
$theme[26]['NAME'] = 'Spice of Life - Lite (Changes)';

$theme[27]['PATH'] = SM_PATH . 'themes/spice_of_life_dark.php';
$theme[27]['NAME'] = 'Spice of Life - Dark (Changes)';

$theme[28]['PATH'] = SM_PATH . 'themes/christmas.php';
$theme[28]['NAME'] = 'Holiday - Christmas';

$theme[29]['PATH'] = SM_PATH . 'themes/darkness.php';
$theme[29]['NAME'] = 'Darkness (Changes)';

$theme[30]['PATH'] = SM_PATH . 'themes/random.php';
$theme[30]['NAME'] = 'Random (Changes every login)';

$theme[31]['PATH'] = SM_PATH . 'themes/midnight.php';
$theme[31]['NAME'] = 'Midnight';

$theme[32]['PATH'] = SM_PATH . 'themes/alien_glow.php';
$theme[32]['NAME'] = 'Alien Glow';

$theme[33]['PATH'] = SM_PATH . 'themes/dark_green.php';
$theme[33]['NAME'] = 'Dark Green';

$theme[34]['PATH'] = SM_PATH . 'themes/penguin.php';
$theme[34]['NAME'] = 'Penguin';

$theme[35]['PATH'] = SM_PATH . 'themes/minimal_bw.php';
$theme[35]['NAME'] = 'Minimal BW';


/**
 * LDAP server(s)
 *   Array of arrays with LDAP server parameters. See
 *   functions/abook_ldap_server.php for a list of possible
 *   parameters
 *
 * EXAMPLE:
 *   $ldap_server[0] = Array(
 *       'host' => 'memberdir.netscape.com',
 *       'name' => 'Netcenter Member Directory',
 *       'base' => 'ou=member_directory,o=netcenter.com'
 *   ); 
 */
// Add your ldap server options here

/**
 * Users may search their addressbook via either a plain HTML or Javascript
 * enhanced user interface. This option allows you to set the default choice.
 * Set this default choice as either:
 *    true  = javascript
 *    false = html
 */
$default_use_javascript_addr_book = false;


/**
 * MOTD
 * This is a message that is displayed immediately after a user logs in. 
 */
$motd = "";


/**
 * To install plugins, just add elements to this array that have
 * the plugin directory name relative to the /plugins/ directory.
 * For instance, for the 'sqclock' plugin, you'd put a line like
 * the following.
 *    $plugins[0] = 'sqclock';
 *    $plugins[1] = 'attachment_common';
 */
// Add list of enabled plugins here


/*** Database ***/
/**
 * Read doc/database.txt in order to get more information 
 * about these settings.
 */
/**
 * Database-driven private addressbooks
 *   DSN (Data Source Name) for a database where the private
 *   addressbooks are stored.  See doc/db-backend.txt for more info.
 *   If it is not set, the addressbooks are stored in files
 *   in the data dir.
 *   The DSN is in the format: mysql://user:pass@hostname/dbname
 *   The table is the name of the table to use within the
 *   specified database.
 */
$addrbook_dsn = '';
$addrbook_table = 'address';
/**
 * Database used to store user data
 */
$prefs_dsn = '';
$prefs_table = 'userprefs';
$prefs_key_field = 'prefkey';
$prefs_user_field = 'user';
$prefs_val_field = 'prefval';
/**
 * Global sql database options
 */
$addrbook_global_dsn = '';
$addrbook_global_table = 'global_abook';
$addrbook_global_writeable = false;
$addrbook_global_listing = false;

/*** Language settings ***/
/**
 * Default language
 *   This is the default language. It is used as a last resort
 *   if SquirrelMail can't figure out which language to display.
 *   Language names usually consist of language code, undercore 
 *   symbol and country code
 */
$squirrelmail_default_language = 'en_US';

/**
 * This option controls what character set is used when sending mail
 * and when sending HTML to the browser. Do not set this to US-ASCII,
 * use ISO-8859-1 instead.
 * 
 * You can set this option, only if $squirrelmail_default_language setting
 * contains 'en_US' string. In any other case system does not allow 
 * making mistakes with incorrect language and charset combinations.
 */
$default_charset = 'iso-8859-1';

/**
 * This option controls number of languages available to end user in
 * language selection preferences. You can use space separated list
 * of translations installed in locale/ directory or special keys
 * 'all' (all languages are available) and 'none' (language selection
 * is disabled, interface is set to $squirrelmail_default_language
 */
$available_languages   = 'all';

/**
 * This options allows displaying native language names in language 
 * selection box.
 */
$show_alternative_names   = false;

/**
 * This option enables reading of Eastern multibyte encodings. 
 * Functions that provide this support are very cpu and memory intensive.
 * Don't enable this option unless you really need it.
 */
$agresive_decoding = false;

/*** Tweaks ***/
/**
 * Use experimental DHTML folder listing
 */
$advanced_tree = false;
/**
 * Use older way of folder listing
 */
$oldway = false;
/**
 * Use experimental code with php recode functions when reading messages with
 * different encoding. This code is faster that original SM functions,
 * but it require php with recode support.
 * 
 * Don't enable this option if you are not sure about availability of 
 * recode support.
 */
$use_php_recode = false;
/**
 * Use experimental code with php iconv functions when reading messages with
 * different encoding. This code is faster that original SM functions,
 * but it require php with iconv support and works only with some translations.
 * 
 * Don't enable this option if you are not sure about availability of 
 * iconv support.
 */
$use_php_iconv = false;

/**
 * this disables listing all of the folders on the IMAP Server to
 * generate the folder subscribe listbox (this can take a long time
 * when you have a lot of folders).  Instead, a textbox will be
 * displayed allowing users to enter a specific folder name to subscribe to
 * 
 * This option can't be changed by conf.pl
 */
$no_list_for_subscribe = false;

/**
 * This option is used only by conf.pl script to generate configuration
 * menu with some colors and is provided here only as reference. 
 */
$config_use_color = 2;

/**
 * This option includes special configuration options
 */
@include SM_PATH . 'config/config_local.php';

/**
 * Make sure there are no characters after the PHP closing
 * tag below (including newline characters and whitespace).
 * Otherwise, that character will cause the headers to be
 * sent and regular output to begin, which will majorly screw
 * things up when we try to send more headers later.
 */
?>