/* sqlheavy-table-cursor.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-table-cursor.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SQLHeavyTableCursorPrivate {
	SQLHeavyTable* _table;
	gint64 _offset;
	SQLHeavySortOrder _sort_order;
	gchar* _sort_column;
	gint64 current_id;
	SQLHeavyQuery* _query;
};


static gpointer sql_heavy_table_cursor_parent_class = NULL;
static SQLHeavyRecordSetIface* sql_heavy_table_cursor_sql_heavy_record_set_parent_iface = NULL;
static SQLHeavyCursorIface* sql_heavy_table_cursor_sql_heavy_cursor_parent_iface = NULL;

#define SQL_HEAVY_TABLE_CURSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_TABLE_CURSOR, SQLHeavyTableCursorPrivate))
enum  {
	SQL_HEAVY_TABLE_CURSOR_DUMMY_PROPERTY,
	SQL_HEAVY_TABLE_CURSOR_TABLE,
	SQL_HEAVY_TABLE_CURSOR_OFFSET,
	SQL_HEAVY_TABLE_CURSOR_SORT_ORDER,
	SQL_HEAVY_TABLE_CURSOR_SORT_COLUMN,
	SQL_HEAVY_TABLE_CURSOR_FIELD_COUNT
};
static SQLHeavyRecord* sql_heavy_table_cursor_real_get (SQLHeavyCursor* base, GError** error);
const gchar* sql_heavy_sqlite_errstr (gint ec);
static gboolean sql_heavy_table_cursor_move_to_internal (SQLHeavyTableCursor* self, gint64 offset);
static SQLHeavyQuery* sql_heavy_table_cursor_get_query (SQLHeavyTableCursor* self);
static void sql_heavy_table_cursor_set_offset (SQLHeavyTableCursor* self, gint64 value);
static gboolean sql_heavy_table_cursor_real_move_to (SQLHeavyCursor* base, gint64 offset, GError** error);
static gboolean sql_heavy_table_cursor_real_next (SQLHeavyRecordSet* base, GError** error);
static gboolean sql_heavy_table_cursor_real_previous (SQLHeavyCursor* base, GError** error);
static GObject * sql_heavy_table_cursor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sql_heavy_table_cursor_finalize (GObject* obj);
static void _vala_sql_heavy_table_cursor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_table_cursor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * {@inheritDoc}
     */
static SQLHeavyRecord* sql_heavy_table_cursor_real_get (SQLHeavyCursor* base, GError** error) {
	SQLHeavyTableCursor * self;
	SQLHeavyRecord* result = NULL;
	SQLHeavyRow* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyTableCursor*) base;
	if (self->priv->current_id <= 0) {
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		_tmp0_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp1_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp0_);
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = sql_heavy_row_new (self->priv->_table, self->priv->current_id);
	result = (SQLHeavyRecord*) _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean sql_heavy_table_cursor_move_to_internal (SQLHeavyTableCursor* self, gint64 offset) {
	gboolean result = FALSE;
	gint64 id;
	SQLHeavyQuery* _tmp0_ = NULL;
	SQLHeavyQuery* _tmp1_;
	SQLHeavyQuery* q;
	SQLHeavyQueryResult* _tmp2_ = NULL;
	SQLHeavyQueryResult* res;
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	id = (gint64) (-1);
	_tmp0_ = sql_heavy_table_cursor_get_query (self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	q = _tmp1_;
	sql_heavy_query_set_int64 (q, ":offset", offset, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (q);
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			goto __catch40_sql_heavy_error;
		}
		_g_object_unref0 (q);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = sql_heavy_query_execute (q, NULL, &_inner_error_, NULL);
	res = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (q);
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			goto __catch40_sql_heavy_error;
		}
		_g_object_unref0 (q);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp4_ = sql_heavy_query_result_get_finished (res);
	if (_tmp4_) {
		_tmp3_ = (gint64) (-1);
	} else {
		gint64 _tmp5_;
		_tmp5_ = sql_heavy_record_fetch_int64 ((SQLHeavyRecord*) res, 0, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (res);
			_g_object_unref0 (q);
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch40_sql_heavy_error;
			}
			_g_object_unref0 (res);
			_g_object_unref0 (q);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	id = _tmp3_;
	_g_object_unref0 (res);
	_g_object_unref0 (q);
	goto __finally40;
	__catch40_sql_heavy_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("sqlheavy-table-cursor.vala:67: Unable to move cursor: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally40:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (id > 0) {
		g_debug ("sqlheavy-table-cursor.vala:72: Offset: %lld", offset);
		self->priv->current_id = id;
		sql_heavy_table_cursor_set_offset (self, offset);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


/**
     * {@inheritDoc}
     */
static gboolean sql_heavy_table_cursor_real_move_to (SQLHeavyCursor* base, gint64 offset, GError** error) {
	SQLHeavyTableCursor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	self = (SQLHeavyTableCursor*) base;
	_tmp0_ = sql_heavy_table_cursor_move_to_internal (self, offset);
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp2_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp1_);
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


/**
     * {@inheritDoc}
     */
static gboolean sql_heavy_table_cursor_real_next (SQLHeavyRecordSet* base, GError** error) {
	SQLHeavyTableCursor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (SQLHeavyTableCursor*) base;
	_tmp0_ = sql_heavy_table_cursor_move_to_internal (self, self->priv->_offset + 1);
	result = _tmp0_;
	return result;
}


/**
     * {@inheritDoc}
     */
static gboolean sql_heavy_table_cursor_real_previous (SQLHeavyCursor* base, GError** error) {
	SQLHeavyTableCursor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (SQLHeavyTableCursor*) base;
	_tmp0_ = sql_heavy_table_cursor_move_to_internal (self, self->priv->_offset - 1);
	result = _tmp0_;
	return result;
}


/**
     * Create a new cursor for the table
     *
     * @param table the table to create the cursor for
     */
SQLHeavyTableCursor* sql_heavy_table_cursor_construct (GType object_type, SQLHeavyTable* table) {
	SQLHeavyTableCursor * self = NULL;
	g_return_val_if_fail (table != NULL, NULL);
	self = (SQLHeavyTableCursor*) g_object_new (object_type, "table", table, NULL);
	return self;
}


SQLHeavyTableCursor* sql_heavy_table_cursor_new (SQLHeavyTable* table) {
	return sql_heavy_table_cursor_construct (SQL_HEAVY_TYPE_TABLE_CURSOR, table);
}


SQLHeavyTable* sql_heavy_table_cursor_get_table (SQLHeavyTableCursor* self) {
	SQLHeavyTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_table;
	return result;
}


static void sql_heavy_table_cursor_set_table (SQLHeavyTableCursor* self, SQLHeavyTable* value) {
	SQLHeavyTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_table);
	self->priv->_table = _tmp0_;
	g_object_notify ((GObject *) self, "table");
}


gint64 sql_heavy_table_cursor_get_offset (SQLHeavyTableCursor* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_offset;
	return result;
}


static void sql_heavy_table_cursor_set_offset (SQLHeavyTableCursor* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_offset = value;
	g_object_notify ((GObject *) self, "offset");
}


SQLHeavySortOrder sql_heavy_table_cursor_get_sort_order (SQLHeavyTableCursor* self) {
	SQLHeavySortOrder result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sort_order;
	return result;
}


void sql_heavy_table_cursor_set_sort_order (SQLHeavyTableCursor* self, SQLHeavySortOrder value) {
	g_return_if_fail (self != NULL);
	self->priv->_sort_order = value;
	g_object_notify ((GObject *) self, "sort-order");
}


const gchar* sql_heavy_table_cursor_get_sort_column (SQLHeavyTableCursor* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sort_column;
	return result;
}


void sql_heavy_table_cursor_set_sort_column (SQLHeavyTableCursor* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sort_column);
	self->priv->_sort_column = _tmp0_;
	g_object_notify ((GObject *) self, "sort-column");
}


gint sql_heavy_table_cursor_get_field_count (SQLHeavyTableCursor* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = sql_heavy_table_get_field_count (self->priv->_table);
	result = _tmp0_;
	return result;
}


static SQLHeavyQuery* sql_heavy_table_cursor_get_query (SQLHeavyTableCursor* self) {
	SQLHeavyQuery* result;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_query == NULL) {
		const gchar* _tmp0_ = NULL;
		SQLHeavyQueryable* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		SQLHeavyQuery* _tmp19_ = NULL;
		SQLHeavyQuery* _tmp20_;
		SQLHeavyQuery* _tmp21_;
		if (self->priv->_sort_order == SQL_HEAVY_SORT_ORDER_ASCENDING) {
			_tmp0_ = "ASC";
		} else {
			_tmp0_ = "DESC";
		}
		_tmp1_ = sql_heavy_table_get_queryable (self->priv->_table);
		_tmp2_ = sql_heavy_table_get_name (self->priv->_table);
		_tmp3_ = sql_heavy_escape_string (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("SELECT `ROWID` FROM `", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, "` ORDER BY `", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = sql_heavy_escape_string (self->priv->_sort_column);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, "` ", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, _tmp0_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, " LIMIT 1 OFFSET :offset;", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = sql_heavy_queryable_prepare (_tmp1_, _tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				goto __catch41_sql_heavy_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->priv->_query);
		self->priv->_query = _tmp21_;
		goto __finally41;
		__catch41_sql_heavy_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("sqlheavy-table-cursor.vala:40: Unable to create table cursor: %s", e->message);
			_g_error_free0 (e);
		}
		__finally41:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = self->priv->_query;
	return result;
}


static GObject * sql_heavy_table_cursor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SQLHeavyTableCursor * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (sql_heavy_table_cursor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SQL_HEAVY_TABLE_CURSOR (obj);
	sql_heavy_record_set_next ((SQLHeavyRecordSet*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			goto __catch42_sql_heavy_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	goto __finally42;
	__catch42_sql_heavy_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("sqlheavy-table-cursor.vala:109: Unable to create table cursor: %s", e->message);
		_g_error_free0 (e);
	}
	__finally42:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void sql_heavy_table_cursor_class_init (SQLHeavyTableCursorClass * klass) {
	sql_heavy_table_cursor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyTableCursorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_table_cursor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_table_cursor_set_property;
	G_OBJECT_CLASS (klass)->constructor = sql_heavy_table_cursor_constructor;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_table_cursor_finalize;
	/**
	     * The table
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TABLE_CURSOR_TABLE, g_param_spec_object ("table", "table", "table", SQL_HEAVY_TYPE_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The current offset
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TABLE_CURSOR_OFFSET, g_param_spec_int64 ("offset", "offset", "offset", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The order to sort the result set in
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TABLE_CURSOR_SORT_ORDER, g_param_spec_enum ("sort-order", "sort-order", "sort-order", SQL_HEAVY_TYPE_SORT_ORDER, SQL_HEAVY_SORT_ORDER_ASCENDING, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The column to sort the result set by
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TABLE_CURSOR_SORT_COLUMN, g_param_spec_string ("sort-column", "sort-column", "sort-column", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * {@inheritDoc}
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_TABLE_CURSOR_FIELD_COUNT, g_param_spec_int ("field-count", "field-count", "field-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sql_heavy_table_cursor_sql_heavy_record_set_interface_init (SQLHeavyRecordSetIface * iface) {
	sql_heavy_table_cursor_sql_heavy_record_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(SQLHeavyRecordSet* ,GError**)) sql_heavy_table_cursor_real_next;
}


static void sql_heavy_table_cursor_sql_heavy_cursor_interface_init (SQLHeavyCursorIface * iface) {
	sql_heavy_table_cursor_sql_heavy_cursor_parent_iface = g_type_interface_peek_parent (iface);
	iface->get = (SQLHeavyRecord* (*)(SQLHeavyCursor* ,GError**)) sql_heavy_table_cursor_real_get;
	iface->move_to = (gboolean (*)(SQLHeavyCursor* ,gint64 ,GError**)) sql_heavy_table_cursor_real_move_to;
	iface->previous = (gboolean (*)(SQLHeavyCursor* ,GError**)) sql_heavy_table_cursor_real_previous;
}


static void sql_heavy_table_cursor_instance_init (SQLHeavyTableCursor * self) {
	gchar* _tmp0_;
	self->priv = SQL_HEAVY_TABLE_CURSOR_GET_PRIVATE (self);
	self->priv->_offset = (gint64) 0;
	self->priv->_sort_order = SQL_HEAVY_SORT_ORDER_ASCENDING;
	_tmp0_ = g_strdup ("ROWID");
	self->priv->_sort_column = _tmp0_;
	self->priv->current_id = (gint64) (-1);
	self->priv->_query = NULL;
}


static void sql_heavy_table_cursor_finalize (GObject* obj) {
	SQLHeavyTableCursor * self;
	self = SQL_HEAVY_TABLE_CURSOR (obj);
	_g_object_unref0 (self->priv->_table);
	_g_free0 (self->priv->_sort_column);
	_g_object_unref0 (self->priv->_query);
	G_OBJECT_CLASS (sql_heavy_table_cursor_parent_class)->finalize (obj);
}


/**
   * Cursor for use with a {@link Table}
   */
GType sql_heavy_table_cursor_get_type (void) {
	static volatile gsize sql_heavy_table_cursor_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_table_cursor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyTableCursorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_table_cursor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyTableCursor), 0, (GInstanceInitFunc) sql_heavy_table_cursor_instance_init, NULL };
		static const GInterfaceInfo sql_heavy_record_set_info = { (GInterfaceInitFunc) sql_heavy_table_cursor_sql_heavy_record_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo sql_heavy_cursor_info = { (GInterfaceInitFunc) sql_heavy_table_cursor_sql_heavy_cursor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sql_heavy_table_cursor_type_id;
		sql_heavy_table_cursor_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyTableCursor", &g_define_type_info, 0);
		g_type_add_interface_static (sql_heavy_table_cursor_type_id, SQL_HEAVY_TYPE_RECORD_SET, &sql_heavy_record_set_info);
		g_type_add_interface_static (sql_heavy_table_cursor_type_id, SQL_HEAVY_TYPE_CURSOR, &sql_heavy_cursor_info);
		g_once_init_leave (&sql_heavy_table_cursor_type_id__volatile, sql_heavy_table_cursor_type_id);
	}
	return sql_heavy_table_cursor_type_id__volatile;
}


static void _vala_sql_heavy_table_cursor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyTableCursor * self;
	self = SQL_HEAVY_TABLE_CURSOR (object);
	switch (property_id) {
		case SQL_HEAVY_TABLE_CURSOR_TABLE:
		g_value_set_object (value, sql_heavy_table_cursor_get_table (self));
		break;
		case SQL_HEAVY_TABLE_CURSOR_OFFSET:
		g_value_set_int64 (value, sql_heavy_table_cursor_get_offset (self));
		break;
		case SQL_HEAVY_TABLE_CURSOR_SORT_ORDER:
		g_value_set_enum (value, sql_heavy_table_cursor_get_sort_order (self));
		break;
		case SQL_HEAVY_TABLE_CURSOR_SORT_COLUMN:
		g_value_set_string (value, sql_heavy_table_cursor_get_sort_column (self));
		break;
		case SQL_HEAVY_TABLE_CURSOR_FIELD_COUNT:
		g_value_set_int (value, sql_heavy_table_cursor_get_field_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_table_cursor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyTableCursor * self;
	self = SQL_HEAVY_TABLE_CURSOR (object);
	switch (property_id) {
		case SQL_HEAVY_TABLE_CURSOR_TABLE:
		sql_heavy_table_cursor_set_table (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_TABLE_CURSOR_OFFSET:
		sql_heavy_table_cursor_set_offset (self, g_value_get_int64 (value));
		break;
		case SQL_HEAVY_TABLE_CURSOR_SORT_ORDER:
		sql_heavy_table_cursor_set_sort_order (self, g_value_get_enum (value));
		break;
		case SQL_HEAVY_TABLE_CURSOR_SORT_COLUMN:
		sql_heavy_table_cursor_set_sort_column (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



