#ifndef POSTSCRIPT_H

#ifdef HAVE_CONFIG_H
#include "config.H"
#endif

#ifdef __GNUC__
#  pragma interface
#endif

#include <iostream.h>
#include "graph2D.H"

class TPostScript : public Tgraph2D {
private:
	ostream& o;
	bool landscape;
	greal ymax;
public:
	TPostScript(ostream& o1, greal xmax, greal ymax1,
				greal titlefontsize, greal labelfontsize, greal axisfontsize, greal annotfontsize,
				bool landscape1, const char *papertype);
	void point(greal x, greal y);
	void begin_line(greal x, greal y);
	void vertex(greal x1, greal y1);
	void end_line();
	void begin_fill(greal x, greal y);
	void end_fill();
	bool polygons_always_convex() const {return false;}
	void circle(greal x, greal y, greal r);
	void fillcircle(greal x, greal y, greal r);
	void text(greal x, greal y, const char *s, int Xoffset, int Yoffset, bool rotate);
	void text_exponent(greal x, greal y, const char *mant, const char *expo, int Xoffset, int Yoffset);
	void comment(greal x, greal y);
	void comment(const char *s);
	void setfont(TFontType font);
	void setlinewidth(greal lw);
	void setlinetype(TLineType lt);
	void setcolor(const greal rgb[3]);
	void setcolor(int i);
	void begin_clipped(greal x1, greal y1, greal x2, greal y2);
	void end_clipped();
	void fillrrect(greal x1, greal y1, greal dx, greal dy);
	void fillrrect_interp(greal x1, greal y1, greal dx, greal dy, int u1, int u2, int u3, int u4);
	void setpalette(const int pal[3][Ncolors]);
	void gsave();
	void grestore();
	~TPostScript();
};

#define POSTSCRIPT_H

#endif
