/*
 * expr.h: header for expr.cpp.
 */

/*
 * Class implementing a function that maps variable names to spigots.
 * Optionally provide one of these to expr_parse as a variable scope.
 * Naturally, it returns NULL if the variable name is unrecognised.
 * It's expected to be case sensitive (though, of course, it can
 * behave insensitively if it prefers).
 */
struct GlobalScope {
    virtual Spigot *lookup(const char *varname) = 0;
};

Spigot *expr_parse(const char *expr, GlobalScope *scope);
