/* ====================================================================
 * Copyright (c) 1996-2000 Carnegie Mellon University.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * This work was supported in part by funding from the Defense Advanced 
 * Research Projects Agency and the National Science Foundation of the 
 * United States of America, and the CMU Sphinx Speech Consortium.
 *
 * THIS SOFTWARE IS PROVIDED BY CARNEGIE MELLON UNIVERSITY ``AS IS'' AND 
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY
 * NOR ITS EMPLOYEES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ====================================================================
 *
 */

#ifndef _WAVE2FEAT_H_
#define _WAVE2FEAT_H_

#define NULL_CHAR '\0'
#define MAXCHARS 2048

/* Huh? */
#define ONE_CHAN "1"

/* Enums for wavefile types. */
enum {
    WAV = 1,
    RAW = 2,
    NIST = 3,
    MSWAV = 4
};

/* Enums for input endianness. */
enum {
    LITTLE =  1,
    BIG =  2
};

/* Enums for conversion operations. */
enum {
    WAV2FEAT = 0,
    SPEC2CEP = 1,
    CEP2SPEC = 2
};

#define COUNT_PARTIAL 1
#define COUNT_WHOLE 0
#define HEADER_BYTES 1024

/** RIFF 44-byte header structure for MS wav files */
typedef struct RIFFHeader{
        char rifftag[4];      /* "RIFF" string */
        int32 TotalLength;      /* Total length */
        char wavefmttag[8];   /* "WAVEfmt " string (note space after 't') */
        int32 RemainingLength;  /* Remaining length */
        int16 data_format;    /* data format tag, 1 = PCM */
        int16 numchannels;    /* Number of channels in file */
        int32 SamplingFreq;     /* Sampling frequency */
        int32 BytesPerSec;      /* Average bytes/sec */
        int16 BlockAlign;     /* Block align */
        int16 BitsPerSample;  /* 8 or 16 bit */
        char datatag[4];      /* "data" string */
        int32 datalength;       /* Raw data length */
} MSWAV_hdr;

extern int32 g_nskip, g_runlen;

#endif
